% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbours.R
\name{neighbours}
\alias{neighbours}
\alias{addNeighbours}
\alias{getAllNeighbours}
\title{neighbours}
\usage{
neighbours(areas = NULL, virtualAreas = NULL)

addNeighbours(antaresData = NULL)

getAllNeighbours(areasString = NULL, virtualAreas = NULL)
}
\arguments{
\item{areas}{A vector with several areas names.}

\item{virtualAreas}{A vector with several virtual areas names.}

\item{antaresData}{Object of class \code{antaresData} created with function
\code{\link[antaresRead]{readAntares}}.}

\item{areasString}{A string with several areas names separated by an espace,
see the examples.}
}
\value{
\code{neighbours} return a vector with neighbours areas names.
\code{addNeighbours} modifies its input by adding a column neighbours.
\code{getAllNeighbours} return a vector with neighbours areas names.
}
\description{
This function return a list of neighbours.
}
\examples{
\dontrun{

res <- neighbours(areas = c("a", "c"),
virtualAreas = getAreas("psp"))

myData <- readAntares(areas = c("a", "c"), links = getLinks("a"),
showProgress = FALSE)

addNeighbours(myData)

res <- getAllNeighbours(areasString = "a b")
}
}
