% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createPSP.R
\name{createPSP}
\alias{createPSP}
\alias{getCapacityPSP}
\alias{editPSP}
\title{Create a Pumped Storage Power plant (PSP)}
\usage{
createPSP(
  areasAndCapacities = NULL,
  namePumping = "Psp_In",
  nameTurbining = "Psp_Out",
  hurdleCost = 5e-04,
  timeStepBindConstraint = "weekly",
  efficiency = NULL,
  overwrite = FALSE,
  opts = antaresRead::simOptions()
)

getCapacityPSP(
  area = NULL,
  nameTurbining = "Psp_Out",
  timeStepBindConstraint = "weekly",
  opts = antaresRead::simOptions()
)

editPSP(
  area = NULL,
  capacity = NULL,
  namePumping = "Psp_In",
  nameTurbining = "Psp_Out",
  timeStepBindConstraint = "weekly",
  hurdleCost = 5e-04,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{areasAndCapacities}{A data.frame with 2 columns \code{installedCapacity} and \code{area}.}

\item{namePumping}{The name of the pumping area}

\item{nameTurbining}{The name of the turbining area}

\item{hurdleCost}{The cost of the PSP}

\item{timeStepBindConstraint}{Time step for the binding constraint : \code{daily} or \code{weekly}}

\item{efficiency}{The efficiency of the PSP}

\item{overwrite}{Overwrite the Pumped Storage Power plant if already exist.
This will overwrite the previous area and links.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}

\item{area}{an area name}

\item{capacity}{PSP capacity for the area}
}
\value{
An updated list containing various information about the simulation.

\code{getCapacityPSP()} returns PSP capacity of the area
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Create a Pumped Storage Power plant (PSP)
}
\examples{
\dontrun{

library(antaresEditObject)
path<-pathToYourStudy
opts<-setSimulationPath(path, simulation = "input")
pspData<-data.frame(area=c("a", "b"), installedCapacity=c(800,900))

createPSP(pspData, efficiency = 0.8)

createPSP(pspData, efficiency = 0.66, overwrite = TRUE)
createPSP(pspData, efficiency = 0.98, timeStepBindConstraint = "daily")
getAreas()

}

\dontrun{

getCapacityPSP("a")
editPSP("a", capacity = 8000, hurdleCost = 0.1)
getCapacityPSP("a")

areaName<-"suisse"
createArea(areaName, overwrite = TRUE)
pspData<-data.frame(area=c(areaName), installedCapacity=c(9856))
createPSP(pspData, efficiency = 0.5, overwrite = TRUE, timeStepBindConstraint = "daily")

getCapacityPSP(areaName, timeStepBindConstraint = "daily")


}
}
