% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomaly_series.R
\name{anomaly_series}
\alias{anomaly_series}
\title{A technique for detecting anomalous segments based on CAPA (Collective And Point Anomaly) by Fisch et al.}
\usage{
anomaly_series(x, penaltywindow = NULL, penaltyanomaly = NULL,
  minimumsegmentlength = 10, warnings = TRUE)
}
\arguments{
\item{x}{A numeric vector containing the data which is to be inspected.}

\item{penaltywindow}{A numeric constant indicating the penalty for adding an additional epidemic changepoint. It defaults to a BIC style penalty if no argument is provided.}

\item{penaltyanomaly}{A numeric constant indicating the penalty for adding an additional point anomaly. It defaults to a BIC style penalty if no argument is provided.}

\item{minimumsegmentlength}{An integer indicating the minimum length of epidemic changes. It must be at least 2 and defaults to 10.}

\item{warnings}{A logical determining whether the warnings should be displayed. It defaults to TRUE.}
}
\value{
An anomaly_series object.
}
\description{
CAPA (Collective And Point Anomaly) by A. T. M. Fisch, I. A. Eckley, and P. N. Fearnhead assumes that the data has a certain mean and variance for most
timepoints and detects segments in which the mean and/or variance deviates from the typical mean and variance as collective anomalies. It also detects point
outliers and returns a measure of strength for the changes in mean and variance. If the number of anomalous windows scales linearly with the number of
data points, CAPA scales linearly with the number of data points. At
worst, if there are no anomalies at all, the computational cost of CAPA scales quadratically with the number of data points.
}
\examples{
library(anomaly)
set.seed(2018)
# Generate data typically following a normal distribution with mean 0 and variance 1. 
# Then introduce 3 anomaly windows and 4 point outliers.
x  = rnorm(5000)
x[401:500]   = rnorm(100,4,1)
x[1601:1800] = rnorm(200,0,0.01)
x[3201:3500] = rnorm(300,0,10)
x[c(1000,2000,3000,4000)] = rnorm(4,0,100)
inferred_anomalies = anomaly_series(x)
plot(inferred_anomalies)
summary(inferred_anomalies)
print(inferred_anomalies)

### Real data example: 

library(anomaly)
data(Lightcurves)
### Plot the data for Kepler 10965588: No transit apparent
plot(Lightcurves$Kepler10965588$Day,Lightcurves$Kepler10965588$Brightness,xlab = "Day",pch=".")
### Examine a period of 62.9 days for Kepler 10965588
binned_data = period_average(Lightcurves$Kepler10965588,62.9)
inferred_anomalies = anomaly_series(binned_data)
plot(inferred_anomalies,xlab="Bin")
# We found a planet! 

}
\references{
  \insertRef{2018arXiv180601947F}{anomaly}
}


