% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark-structured-streaming-utilities.R
\name{convertKafkaValueFromJson}
\alias{convertKafkaValueFromJson}
\title{Connect to a Spark session}
\usage{
convertKafkaValueFromJson(streamObj, schema)
}
\arguments{
\item{streamObj}{Spark Structured Streaming DataFrame which is returned by the \code{castKafkaStreamAsString} function}

\item{schema}{A structType object created from SparkR specifying the schema of the json data present in the \code{value}
attribute of the incoming Kafka stream}
}
\value{
Spark Structured Streaming DataFrame with the json data in the \code{value} attribute of the Kafka stream parsed
into a DataFrame format
}
\description{
Connect to a Spark session
}
\details{
Takes in a Structured Stream from Kafka created from \code{read.stream(source = 'kafka', ...)} and returns
a Structured Streaming DataFrame where the \code{key} and \code{value} from the Kafka stream are cast to string
}
\seealso{
Other Spark utilities: \code{\link{castKafkaStreamAsString}},
  \code{\link{sparkRSessionCreateIfNotPresent}}
}
\concept{Spark utilities}
