% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractal-billow.R
\name{billow}
\alias{billow}
\title{Billow (cloud-like, lumpy) fractal}
\usage{
billow(base, new, strength, ...)
}
\arguments{
\item{base}{The prior values to modify}

\item{new}{The new values to modify \code{base} with}

\item{strength}{A value to modify \code{new} with before applying it to \code{base}}

\item{...}{ignored}
}
\description{
The billow fractal is a slight modification of the \code{\link[=fbm]{fbm()}} fractal. Before
adding the new layer onto the last, the new layer is modified by taking the
absolute value, multiplying by 2, and subtracting one. The result is that the
new value will not contain negative values and so will always add on top of
the old values. This function is intended to be used in conjunction with
\code{\link[=fracture]{fracture()}}
}
\examples{
grid <- long_grid(seq(1, 10, length.out = 1000), seq(1, 10, length.out = 1000))

grid$simplex <- fracture(gen_simplex, billow, octaves = 8, x = grid$x,
                         y = grid$y)
plot(grid, simplex)

}
\seealso{
Other Fractal functions: 
\code{\link{clamped}()},
\code{\link{fbm}()},
\code{\link{ridged}()}
}
\concept{Fractal functions}
