% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.rel.error}
\alias{intFun.rel.error}
\title{Relative error used for binned data}
\usage{
intFun.rel.error(mod, ref)
}
\arguments{
\item{mod}{An R object (binned time means of model output)}

\item{ref}{An R object (binned time means of reference data)}
}
\value{
An R object
}
\description{
This function computes the relative error for binned data used
for assessing functional relationships:
\eqn{$\varepsilon_{func}^u=\sqrt{\frac{\int(f_{mod}(u)-f_{ref}(u))^2du}{\int f_{ref}(u)^2du}}$}

where \eqn{f_{mod}(u)} and \eqn{f_{ref}(u)} are the binned time means of
the model and reference data, respectively.
}
\examples{

# make some data
mod <- runif(100,0,10)
ref <- runif(100,0,10)
# compute relative error
r <- intFun.rel.error(mod,ref)

}
\keyword{internal}
