% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.functional.response.R
\name{scores.functional.response}
\alias{scores.functional.response}
\title{Response of a variable to its forcing}
\usage{
scores.functional.response(nc.mod.x, nc.mod.y, nc.ref.x, nc.ref.y, mod.id,
  ref.id, unit.conv.mod.x, unit.conv.mod.y, unit.conv.ref.x,
  unit.conv.ref.y, x.bin, y.bin, my.xlab, my.ylab, legendA = "topleft",
  legendB = "topleft", outputDir = FALSE)
}
\arguments{
\item{nc.mod.x}{A string that gives the path and name of the netcdf file that contains the model forcing data, e.g. '/home/model_tas.nc'}

\item{nc.mod.y}{A string that gives the path and name of the netcdf file that contains the model output data, e.g. '/home/model_gpp.nc'}

\item{nc.ref.x}{A string that gives the path and name of the netcdf file that contains the reference forcing data, e.g. '/home/ref_tas.nc'}

\item{nc.ref.y}{A string that gives the path and name of the netcdf file that contains the reference data, e.g. '/home/ref_gpp.nc'}

\item{mod.id}{A string that identifies the source of the reference data set, e.g. 'CLASSIC'}

\item{ref.id}{A string that identifies the source of the reference data set, e.g. 'MODIS'}

\item{unit.conv.mod.x}{A number that is used as a factor to convert the unit of the model forcing data, e.g. 86400}

\item{unit.conv.mod.y}{A number that is used as a factor to convert the unit of the model output data, e.g. 86400}

\item{unit.conv.ref.x}{A number that is used as a factor to convert the unit of the reference forcing data, e.g. 86400}

\item{unit.conv.ref.y}{A number that is used as a factor to convert the unit of the reference data, e.g. 86400}

\item{x.bin}{A number that gives the size of the x-bin, e.g. 2}

\item{y.bin}{A number that gives the size of the y-bin, e.g. 2}

\item{my.xlab}{A string that serves as the label for the x-axis, e.g. expression(paste('near surface air temperature (',degree,'C)')) # (R notation)}

\item{my.ylab}{A string that serves as the label for the y-axis, e.g. expression('GPP (g C m'^{-2}~'day'^{-1}~')') # (R notation)}

\item{legendA}{A string that defines the legend location for the upper subplot. The default value is 'topleft'.}

\item{legendB}{A string that defines the legend location for the lower subplot. The default value is 'topleft'.}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
A figure in PDF format that shows the functional relation
ship between two variables, the frequency of grid cells for each bin,
and the score value.
}
\description{
This function conducts a relationship analysis by assessing the functional
response of two variables. The variables consist of a dependent variable \eqn{y}
(e.g. GPP) and an independent variable \eqn{x} (e.g. temperature).
Usually, there are 4 datasets involved:
(1) modeled \eqn{x}, (2) modeled \eqn{y}, (3) reference \eqn{x}, (4) reference \eqn{y},
where \eqn{reference} refers to observation-based datasets. The time period of
analysis should cover the period that all data sets have in common.
When the model is forced with observations, (1) and (3) are identical.
The common time period is then defined by (2) and (4).
The performance of a model is expressed through a score value that ranges
from zero to one, where increasing values imply better performance:

\eqn{$\varepsilon_{func}^u=\sqrt{\frac{\int(f_{mod}(u)-f_{ref}(u))^2du}{\int f_{ref}(u)^2du}}$}

where \eqn{f_{mod}(u)} and \eqn{f_{ref}(u)} are the binned time means of
the model and reference data, respectively.
}
\examples{

library(amber)
library(ncdf4)
library(raster)
nc.mod.x <- system.file('extdata/modelRegular', 'tas_monthly.nc', package = 'amber')
nc.mod.y <- system.file('extdata/modelRegular', 'gpp_monthly.nc', package = 'amber')
nc.ref.x <- system.file('extdata/modelRegular', 'tas_monthly.nc', package = 'amber')
nc.ref.y <- system.file('extdata/referenceRegular', 'gpp_GBAF_128x64.nc', package = 'amber')
mod.id <- 'CLASSIC' # define a model experiment ID
ref.id <- 'GBAF' # give reference dataset a name
unit.conv.mod.x <- 1
unit.conv.mod.y <- 86400*1000
unit.conv.ref.x <- 1
unit.conv.ref.y <- 86400*1000
x.bin <- 2.5 # adjust as required
y.bin <- 1 # adjust as required
my.xlab <- expression(paste('near surface air temperature (',degree,'C)')) # (R notation)
my.ylab <- expression('GPP (g C m'^{-2}~'day'^{-1}~')') # (R notation)

scores.functional.response(nc.mod.x, nc.mod.y, nc.ref.x, nc.ref.y, mod.id,
ref.id, unit.conv.mod.x, unit.conv.mod.y, unit.conv.ref.x, unit.conv.ref.y,
x.bin, y.bin, my.xlab, my.ylab)

}
