% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_tri}
\alias{download_tri}
\title{Download toxic release data}
\usage{
download_tri(
  year = c(2018L, 2022L),
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  hash = FALSE
)
}
\arguments{
\item{year}{character(1 or 2). length of 4. Year or start/end years for downloading data.}

\item{directory_to_save}{character(1). Directory to download files.}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). \code{FALSE} will generate a *.txt file
containing all download commands. By setting \code{TRUE} the function
will download all of the requested data files.}

\item{remove_command}{logical(1). Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}

\item{hash}{logical(1). By setting \code{TRUE} the function will return
an \code{rlang::hash_file()} hash character corresponding to the
downloaded files. Default is \code{FALSE}.}
}
\value{
\itemize{
\item For \code{hash = FALSE}, NULL
\item For \code{hash = TRUE}, an \code{rlang::hash_file} character.
\item Comma-separated value (CSV) files will be stored in
\code{directory_to_save}.
}
}
\description{
The \code{download_tri()} function accesses and downloads toxic release data from the \href{https://www.epa.gov/toxics-release-inventory-tri-program/tri-data-action-0}{U.S. Environmental Protection Agency's (EPA) Toxic Release Inventory (TRI) Program}.
}
\examples{
\dontrun{
download_tri(
  year = 2021L,
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
}
}
\references{
\insertRef{web_usepa2024tri}{amadeus}
}
\author{
Mariana Kassien, Insang Song
}
