% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_merra2}
\alias{process_merra2}
\title{Process meteorological and atmospheric data}
\usage{
process_merra2(
  date = c("2018-01-01", "2018-01-01"),
  variable = NULL,
  path = NULL,
  extent = NULL,
  ...
)
}
\arguments{
\item{date}{character(2). length of 10. Format "YYYY-MM-DD".}

\item{variable}{character(1). MERRA2 variable name(s).}

\item{path}{character(1). Directory with downloaded netCDF (.nc4) files.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object;
}
\description{
The \code{process_merra2()} function imports and cleans raw atmospheric
composition data, returning a single \code{SpatRaster} object.
}
\note{
Layer names of the returned \code{SpatRaster} object contain the variable,
pressure level, date, and hour. Pressure level values utilized for layer
names are taken directly from raw data and are not edited to retain
pressure level information.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
merra2 <- process_merra2(
  date = c("2024-01-01", "2024-01-10"),
  variable = "CPT",
  path = "./data/inst1_2d_int_Nx"
)
}
}
\author{
Mitchell Manware
}
