% Generated by roxygen2 (4.0.2): do not edit by hand
\name{alm_alerts}
\alias{alm_alerts}
\title{Retrieve alerts data for article-level metrics (ALM).}
\usage{
alm_alerts(source = NULL, ids = NULL, class_name = NULL, level = NULL,
  q = NULL, unresolved = FALSE, per_page = 50, page = 1, user = NULL,
  pwd = NULL, url = "http://alm.plos.org/api/v4/alerts", ...)
}
\arguments{
\item{source}{(character) Source to limtit alert search to.}

\item{ids}{(character) Article identifiers}

\item{class_name}{(character) Which error to get}

\item{level}{(character) Alert level to limit search to. One of ERROR, WARN, INFO,
or FATAL. Default: all.}

\item{q}{(character) Query terms}

\item{unresolved}{(logical) Whether to give back unresolved alerts only.}

\item{per_page}{(integer) Number of records to return. Default: 50. Max: ?}

\item{page}{(integer) Number from 1 to number of pages}

\item{user}{(character) Username}

\item{pwd}{(character) Password}

\item{url}{URL to use.}

\item{...}{Further args passed to httr::GET}
}
\description{
Retrieve alerts data for article-level metrics (ALM).
}
\details{
This function uses the alm.plos.org API by default. You can change which ALM app you use by
specifying the url in the url parameter. It will likely be the same as the default
http://alm.plos.org/api/v4/alerts, but just the alm.plos.org part will be different.

ALM installations on the most current version (3.4.7) can be used in this function, as of
2014-08-26 those are PLOS, ALM Labs, and Crossref Labs.
}
\examples{
\dontrun{
alm_alerts()
alm_alerts(q='mismatch')
alm_alerts(unresolved=TRUE)
alm_alerts(class_name='NoMethodError')
alm_alerts(class_name='ApiResponseTooSlowError')
alm_alerts(level='Error')
alm_alerts(ids="10.1371/journal.pone.0029797")

# curl debugging
alm_alerts(level='Error', config=verbose())

# paging
alm_alerts(per_page=2)

out <- alm_alerts(level = "error")
head(out$data)

# Using different ALM apps, e.g, labs.crowdometer.org
alm_alerts(url='http://labs.crowdometer.org/api/v4/alerts')
}
}

