% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/smooth.R
\docType{methods}
\name{smooth_loess}
\alias{smooth_loess}
\alias{smooth_loess-method}
\alias{smooth_loess,numeric,numeric-method}
\alias{smooth_loess,ANY,missing-method}
\title{Loess Smoothing}
\usage{
smooth_loess(x, y, ...)

\S4method{smooth_loess}{numeric,numeric}(x, y, span = 0.75, ...)

\S4method{smooth_loess}{ANY,missing}(x, span = 0.75, ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Extra arguments to be passed to \code{\link[stats:loess]{stats::loess()}}.}

\item{span}{An \code{\link{integer}} specifying the degree of smoothing (see
\code{\link[stats:loess]{stats::loess()}}).}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Smoothes intensities by loess fitting.
}
\examples{
## Simulate data with some noise
x <- seq(-4, 4, length = 100)
y <- dnorm(x) + rnorm(100, mean = 0, sd = 0.01)

## Plot spectrum
plot(x, y, type = "l", xlab = "", ylab = "")

## Rectangular smoothing
unweighted <- smooth_rectangular(x, y, m = 3)
plot(unweighted, type = "l", xlab = "", ylab = "")

## Triangular smoothing
weighted <- smooth_triangular(x, y, m = 5)
plot(weighted, type = "l", xlab = "", ylab = "")

## Loess smoothing
loess <- smooth_loess(x, y, span = 0.75)
plot(loess, type = "l", xlab = "", ylab = "")

## Savitzky–Golay filter
savitzky <- smooth_savitzky(x, y, m = 21, p = 2)
plot(savitzky, type = "l", xlab = "", ylab = "")

## Whittaker smoothing
whittaker <- smooth_whittaker(x, y, lambda = 1600, d = 2)
plot(whittaker, type = "l", xlab = "", ylab = "")
}
\seealso{
Other smoothing methods: 
\code{\link{smooth_likelihood}()},
\code{\link{smooth_rectangular}()},
\code{\link{smooth_savitzky}()},
\code{\link{smooth_triangular}()},
\code{\link{smooth_whittaker}()}
}
\author{
N. Frerebeau
}
\concept{smoothing methods}
