% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snc.R
\name{snc}
\alias{snc}
\title{Fit  Solow and Costello (2004) model}
\usage{
snc(
  y,
  mu = NULL,
  pi = NULL,
  data = NULL,
  init = NULL,
  growth = TRUE,
  type = "exponential",
  ...
)
}
\arguments{
\item{y}{a time series of the annual number of discovered alien and invasive species (IAS)}

\item{mu}{a formula defining the predictors for \eqn{\mu_t}, the annual introduction rate. Formulas should be provided in the syntax \code{~ x1 + x2 + ... + xn}.}

\item{pi}{a formula defining the predictors for \eqn{\Pi_{st}}, the annual probability of detection. Formulas should be provided in the syntax \code{~ x1 + x2 + ... + xn}.}

\item{data}{a data frame containing the variables in the model(s).}

\item{init}{Optional. Initial values supplied to \code{optim}. Must be same length as the total number of parameters.}

\item{growth}{logical. Should the population growth parameter \eqn{\gamma_2} be included in the model for \eqn{\Pi_{st}}?. Note that values for \code{init}, if provided, need to include an initial value for the growth parameter, when \code{growth = TRUE}.}

\item{type}{Define whether the mu function should be on "linear" or "exponential" scale. Defaults to "exponential".}

\item{...}{Further arguments passed to \code{optim}.}
}
\value{
\code{snc} returns an object of class "snc" containing: \tabular{ll}{
\code{records} \tab the supplied first records data \cr
\code{convergence} \tab the \code{optim} convergence code.\cr
\code{log-likelihood} \tab the maximum log-likelihood.\cr
\code{coefficients} \tab a named vector of the ML estimates of the   coefficients.\cr
\code{fitted.values} \tab the fitted mean \eqn{\lambda} values.\cr
\code{predict} \tab a data frame containing the estimated mean +- Standard error \eqn{\mu} values.\cr
}
}
\description{
Fit the model described in Solow and Costello (2004) to data.
It can use external data on either \eqn{\mu_t} or \eqn{\Pi_{st}}.
}
\details{
This function expands on the model described in Solow and Costello (2004) by facilitating the
inclusion of external data to describe either \eqn{\mu_t} or \eqn{\Pi_{st}}.
The model with external data is described fully in Buba et al (2024).
When no formula is defined for either, the function automatically fits the original Solow and Costello (2004)
model using the length of the vector data as the independent variable \eqn{t}.
The original model uses Rcpp for shorter run time.
When numerous estimations are required for a more elaborate model (i.e, for simulation studies or bootstrapping),
users may be benefit from building upon the function described in \code{filename.cpp}
}
\examples{
\donttest{
data(sfestuary)
example_model <- snc(sfestuary)
print(example_model)
}
}
\references{
Solow, A. R., & Costello, C. J. (2004). Estimating the rate of species introductions from the discovery record. Ecology, 85(7), 1822–1825. https://doi.org/10.1890/03-3102
}
