% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{testEdges}
\alias{testEdges}
\title{Tests for parent-child annotation enchrichment in lineage trees}
\usage{
testEdges(
  graphs,
  field,
  indirect = FALSE,
  exclude = c("Germline", NA),
  nperm = 200,
  progress = FALSE
)
}
\arguments{
\item{graphs}{list of igraph objects with vertex annotations.}

\item{field}{string defining the annotation field to permute.}

\item{indirect}{if \code{FALSE} count direct connections (edges) only. If 
\code{TRUE} walk through any nodes with annotations specified in 
the \code{argument} to count indirect connections. Specifying
\code{indirect=TRUE} with \code{exclude=NULL} will have no effect.}

\item{exclude}{vector of strings defining \code{field} values to exclude from 
permutation.}

\item{nperm}{number of permutations to perform.}

\item{progress}{if \code{TRUE} show a progress bar.}
}
\value{
An \link{EdgeTest} object containing the test results and permutation
          realizations.
}
\description{
\code{testEdges} performs a permutation test on a set of lineage trees to determine
the significance of an annotation's association with parent-child relationships.
}
\examples{
\donttest{
# Define example tree set
graphs <- ExampleTrees[1-10]

# Perform edge test on isotypes
x <- testEdges(graphs, "c_call", nperm=10)
print(x)
}

}
\seealso{
Uses \link{tableEdges} and \link{permuteLabels}. 
          See \link{plotEdgeTest} for plotting the permutation distributions.
}
