% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{fleiss_kappa}
\alias{fleiss_kappa}
\title{Calculate Fleiss' Kappa}
\usage{
fleiss_kappa(rater_one, rater_two, additional_raters = NULL)
}
\arguments{
\item{rater_one}{\code{factor} rating of the first coder.}

\item{rater_two}{\code{factor} ratings of the second coder.}

\item{additional_raters}{\code{list} Additional raters with same requirements as \code{rater_one} and \code{rater_two}. If
there are no additional raters set to \code{NULL}.}
}
\value{
Retuns the value for Fleiss' Kappa.
}
\description{
This function calculates Fleiss' Kappa.
}
\references{
Fleiss, J. L. (1971). Measuring nominal scale agreement among
many raters. Psychological Bulletin, 76(5), 378–382. \url{doi:10.1037/h0031619}
}
\seealso{
Other performance measures: 
\code{\link{cohens_kappa}()},
\code{\link{kendalls_w}()},
\code{\link{kripp_alpha}()}
}
\concept{performance measures}
