/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.aibd.distribution;

import java.io.Serializable;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.util.FastMath;
import org.ddahl.aibd.FeatureAllocation;
import org.ddahl.aibd.FeatureAllocation$;
import org.ddahl.aibd.distribution.FeatureAllocationDistribution;
import org.ddahl.aibd.distribution.HasMass;
import org.ddahl.aibd.distribution.IndianBuffetProcess$;
import org.ddahl.aibd.util.Functions$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t4A\u0001E\t\u00015!A\u0011\u0006\u0001BC\u0002\u0013\u0005!\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003,\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0004\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000bU\u0002A\u0011\u0002\u001c\t\u000fe\u0002!\u0019!C\u0001U!1!\b\u0001Q\u0001\n-BQa\u000f\u0001\u0005\u0002qBQA\u0010\u0001\u0005\u0002}BQA\u0010\u0001\u0005\u0002!CQA\u0013\u0001\u0005\u0002-;QAW\t\t\u0002m3Q\u0001E\t\t\u0002qCQ!N\u0007\u0005\u0002uCQAX\u0007\u0005\u0002}\u00131#\u00138eS\u0006t')\u001e4gKR\u0004&o\\2fgNT!AE\n\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u000b\u0005Q)\u0012\u0001B1jE\u0012T!AF\f\u0002\u000b\u0011$\u0017\r\u001b7\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u000e\"KA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0012\u000e\u0003EI!\u0001J\t\u0003;\u0019+\u0017\r^;sK\u0006cGn\\2bi&|g\u000eR5tiJL'-\u001e;j_:\u00042A\t\u0014)\u0013\t9\u0013CA\u0004ICNl\u0015m]:\u0011\u0005\t\u0002\u0011\u0001B7bgN,\u0012a\u000b\t\u000391J!!L\u000f\u0003\r\u0011{WO\u00197f\u0003\u0015i\u0017m]:!\u0003\u0019q\u0017\n^3ngV\t\u0011\u0007\u0005\u0002\u001de%\u00111'\b\u0002\u0004\u0013:$\u0018a\u00028Ji\u0016l7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!:\u0004\bC\u0003*\u000b\u0001\u00071\u0006C\u00030\u000b\u0001\u0007\u0011'A\u0004m_\u001el\u0015m]:\u0002\u00111|w-T1tg\u0002\n!\"\u001e9eCR,W*Y:t)\tAS\bC\u0003*\u0011\u0001\u00071&\u0001\bm_\u001e\u0004&o\u001c2bE&d\u0017\u000e^=\u0015\u0007-\u0002%\tC\u0003B\u0013\u0001\u0007\u0011'A\u0001j\u0011\u0015\u0019\u0015\u00021\u0001E\u0003\t1\u0017\r\u0005\u0002F\r6\t1#\u0003\u0002H'\t\tb)Z1ukJ,\u0017\t\u001c7pG\u0006$\u0018n\u001c8\u0015\u0005-J\u0005\"B\"\u000b\u0001\u0004!\u0015AB:b[BdW\r\u0006\u0002E\u0019\")Qj\u0003a\u0001\u001d\u0006\u0019!\u000fZ4\u0011\u0005=CV\"\u0001)\u000b\u0005E\u0013\u0016A\u0002:b]\u0012|WN\u0003\u0002T)\u0006)Q.\u0019;ig)\u0011QKV\u0001\bG>lWn\u001c8t\u0015\t9v#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u00033B\u00131CU1oI>lG)\u0019;b\u000f\u0016tWM]1u_J\f1#\u00138eS\u0006t')\u001e4gKR\u0004&o\\2fgN\u0004\"AI\u0007\u0014\u00055YB#A.\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007!\u0002\u0017\rC\u0003*\u001f\u0001\u00071\u0006C\u00030\u001f\u0001\u0007\u0011\u0007")
public class IndianBuffetProcess
implements FeatureAllocationDistribution,
HasMass<IndianBuffetProcess> {
    private final double mass;
    private final int nItems;
    private final double logMass;

    public static IndianBuffetProcess apply(double d, int n) {
        return IndianBuffetProcess$.MODULE$.apply(d, n);
    }

    @Override
    public double logProbability(int i, double[][] fa) {
        return FeatureAllocationDistribution.logProbability$((FeatureAllocationDistribution)this, i, fa);
    }

    @Override
    public double[] logProbability(int i, FeatureAllocation[] fa) {
        return FeatureAllocationDistribution.logProbability$((FeatureAllocationDistribution)this, i, fa);
    }

    @Override
    public double[] logProbability(int i, double[][][] fa) {
        return FeatureAllocationDistribution.logProbability$((FeatureAllocationDistribution)this, i, fa);
    }

    @Override
    public double logProbability(double[][] fa) {
        return FeatureAllocationDistribution.logProbability$((FeatureAllocationDistribution)this, fa);
    }

    @Override
    public double[] logProbability(FeatureAllocation[] fa) {
        return FeatureAllocationDistribution.logProbability$((FeatureAllocationDistribution)this, fa);
    }

    @Override
    public double[] logProbability(double[][][] fa) {
        return FeatureAllocationDistribution.logProbability$((FeatureAllocationDistribution)this, fa);
    }

    @Override
    public <B> Object sample(RandomDataGenerator rdg, int nSamples, int nCores, Function1<FeatureAllocation, B> transop, ClassTag<B> evidence$1) {
        return FeatureAllocationDistribution.sample$(this, rdg, nSamples, nCores, transop, evidence$1);
    }

    @Override
    public <B> int sample$default$3() {
        return FeatureAllocationDistribution.sample$default$3$(this);
    }

    @Override
    public <B> Function1<FeatureAllocation, FeatureAllocation> sample$default$4() {
        return FeatureAllocationDistribution.sample$default$4$(this);
    }

    @Override
    public double[][] expectedPairwiseAllocationMatrix(int maxNFeatures) {
        return FeatureAllocationDistribution.expectedPairwiseAllocationMatrix$(this, maxNFeatures);
    }

    @Override
    public double sum(int maxNFeatures) {
        return FeatureAllocationDistribution.sum$(this, maxNFeatures);
    }

    @Override
    public double mass() {
        return this.mass;
    }

    @Override
    public int nItems() {
        return this.nItems;
    }

    @Override
    public double logMass() {
        return this.logMass;
    }

    @Override
    public IndianBuffetProcess updateMass(double mass) {
        if (mass <= 0.0) {
            throw new IllegalArgumentException("'mass' must be positive.");
        }
        return new IndianBuffetProcess(mass, this.nItems());
    }

    @Override
    public double logProbability(int i, FeatureAllocation fa) {
        return this.logProbability(fa);
    }

    @Override
    public double logProbability(FeatureAllocation fa) {
        double const1 = -this.mass() * Functions$.MODULE$.harmonicNumber().apply(fa.nItems());
        if (fa.nFeatures() == 0) {
            return const1;
        }
        double const2 = this.logMass() - Functions$.MODULE$.logFactorial().apply(fa.nItems());
        double sum = const1 + (double)fa.nFeatures() * const2;
        sum -= fa.computeRegardingTies();
        return sum += BoxesRunTime.unboxToDouble((Object)fa.sizes().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDI.sp & Serializable & scala.Serializable)(s, mk) -> s + Functions$.MODULE$.logFactorial().apply(fa.nItems() - mk) + Functions$.MODULE$.logFactorial().apply(mk - 1)));
    }

    @Override
    public FeatureAllocation sample(RandomDataGenerator rdg) {
        int[] nNewFeaturesPerItems = (int[])Array$.MODULE$.tabulate(this.nItems(), (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> (int)rdg.nextPoisson(this.mass() / (double)(i + 1)), ClassTag$.MODULE$.Int());
        int[] nNewFeaturesCumulant = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(nNewFeaturesPerItems)).scan((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        FeatureAllocation fa = FeatureAllocation$.MODULE$.empty(this.nItems());
        for (int i2 = 0; i2 < this.nItems(); ++i2) {
            int j;
            for (j = 0; j < nNewFeaturesCumulant[i2]; ++j) {
                if (!(rdg.nextUniform(0.0, 1.0) <= (double)BoxesRunTime.unboxToInt((Object)fa.sizes().apply(j)) / (double)(i2 + 1))) continue;
                fa = fa.add(i2, j);
            }
            while (j < nNewFeaturesCumulant[i2 + 1]) {
                fa = fa.add(i2);
                ++j;
            }
        }
        return fa;
    }

    public IndianBuffetProcess(double mass, int nItems) {
        this.mass = mass;
        this.nItems = nItems;
        FeatureAllocationDistribution.$init$(this);
        this.logMass = FastMath.log((double)mass);
    }
}

