% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractG.R
\name{extract_vcov}
\alias{extract_vcov}
\title{Extract Variance-Covariance from ASReml-R}
\usage{
extract_vcov(model = NULL, gen = "genotype", env = "trial", vc_model = "corv")
}
\arguments{
\item{model}{ASReml object}

\item{gen}{A character string indicating the column in data that contains
genotypes.}

\item{env}{A character string indicating the column in data that contains
environments or trials.}

\item{vc_model}{A character string indicating the variance-covariance fitted.
Can be 'diag', 'corv', 'corh', 'corgv', 'fa1', 'fa2', 'fa3', 'fa4', 'corgh',
'us' or 'rr2'.}
}
\value{
An object with a list of:
\item{VCOV}{A matrix of the estimated variance-covariance between trials.}
\item{CORR}{A n_trial x n_trial matrix with the correlation between trials.}
\item{vc_model}{A character string indicating the variance-covariance fitted.}
}
\description{
Extract Variance-Covariance from ASReml-R
}
\examples{
\dontrun{
library(agridat)
library(agriutilities)

data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
met_results <- met_analysis(out, progress = FALSE)
extract_vcov(
  model = met_results$met_models$yield,
  vc_model = "us"
)
}
}
