% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{marginal_posterior}
\alias{marginal_posterior}
\title{Marginal Posteriors}
\usage{
marginal_posterior(optresults, k, j)
}
\arguments{
\item{optresults}{The results of calling \code{aghq::optimize_theta()}: see return value of that function.}

\item{k}{Integer, the number of quadrature points to use. I suggest at least 3. k = 1 corresponds to a Laplace
approximation.}

\item{j}{Integer between 1 and the dimension of the parameter space. Which
index of the parameter vector to compute the marginal posterior for.}
}
\value{
a tbl_df/tbl/data.frame containing the normalized log marginal posterior
for theta_j evaluated at the original quadrature points. Has columns
\code{"thetaj","logpost_normalized","weights"}, where \code{j} is the \code{j} you specified.
}
\description{
Compute the marginal posterior for a given parameter using AGHQ.
}
\examples{
## A 2d example ##
logfteta2d <- function(eta,y) {
  # eta is now (eta1,eta2)
  # y is now (y1,y2)
  n <- length(y)
  n1 <- ceiling(n/2)
  n2 <- floor(n/2)
  y1 <- y[1:n1]
  y2 <- y[(n1+1):(n1+n2)]
  eta1 <- eta[1]
  eta2 <- eta[2]
  sum(y1) * eta1 - (length(y1) + 1) * exp(eta1) - sum(lgamma(y1+1)) + eta1 +
    sum(y2) * eta2 - (length(y2) + 1) * exp(eta2) - sum(lgamma(y2+1)) + eta2
}
set.seed(84343124)
n1 <- 5
n2 <- 5
n <- n1+n2
y1 <- rpois(n1,5)
y2 <- rpois(n2,5)
objfunc2d <- function(x) logfteta2d(x,c(y1,y2))
funlist2d <- list(
  fn = objfunc2d,
  gr = function(x) numDeriv::grad(objfunc2d,x),
  he = function(x) numDeriv::hessian(objfunc2d,x)
)
opt_sparsetrust_2d <- optimize_theta(funlist2d,c(1.5,1.5))

# Now actually do the marginal posteriors
marginal_posterior(opt_sparsetrust_2d,3,1)
marginal_posterior(opt_sparsetrust_2d,3,2)
marginal_posterior(opt_sparsetrust_2d,7,2)

}
\seealso{
Other summaries: 
\code{\link{compute_moment}()},
\code{\link{compute_pdf_and_cdf}()},
\code{\link{compute_quantiles}()},
\code{\link{interpolate_marginal_posterior}()}
}
\concept{summaries}
