#' Globular Clusters data for Milky Way mass estimation
#'
#' Measurements on star clusters from Eadie and Harris (2016), for use
#' within the Milky Way mass estimation example. Data are documented
#' extensively by that source.
#'
#' @source Eadie GM, Harris WE (2016). “Bayesian mass estimates of the Milky Way: the dark and light sides of parameter assumptions.” The Astrophysical Journal, 829(108).
#'
"gcdata"

#' Transformed Globular Clusters data
#'
#' GC data prepared for input into the TMB template, for purposes of example.
#' There are a lot of example-specific data preprocessing steps that are not
#' related to the AGHQ method, so for brevity these are done beforehand.
#'
#' @source Eadie GM, Harris WE (2016). “Bayesian mass estimates of the Milky Way: the dark and light sides of parameter assumptions.” The Astrophysical Journal, 829(108).
#'
"gcdatalist"
