% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{plot.aggTrees}
\alias{plot.aggTrees}
\title{Plot Method for aggTrees Objects}
\usage{
\method{plot}{aggTrees}(x, leaves = get_leaves(x$tree), sequence = FALSE, ...)
}
\arguments{
\item{x}{An \code{aggTrees} object.}

\item{leaves}{Number of leaves of the desired tree. This can be used to plot subtrees.}

\item{sequence}{If \code{TRUE}, the whole sequence of optimal groupings is displayed in a short animation.}

\item{...}{Further arguments from \code{\link[rpart.plot]{prp}}.}
}
\value{
None, plots an \code{aggTrees} object.
}
\description{
Plots an \code{aggTrees} object.
}
\details{
Nodes are colored using a diverging palette. Nodes with predictions smaller than the ATE (i.e., the root
prediction) are colored in blue shades, and nodes with predictions larger than the ATE are colored in red
shades. Moreover, predictions that are more distant in absolute value from the ATE get darker shades.
This way, we have an immediate understanding of the groups with extreme GATEs.
}
\references{
\itemize{
  \item R Di Francesco (2022). Aggregation Trees. CEIS Research Paper, 546. \doi{10.2139/ssrn.4304256}.
}
}
\seealso{
\code{\link{build_aggtree}}, \code{\link{analyze_aggtree}}
}
\author{
Riccardo Di Francesco
}
