% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isocubeGrob.r
\name{isocubeGrob}
\alias{isocubeGrob}
\alias{grid.isocube}
\title{Isometric cube grob}
\usage{
isocubeGrob(
  top,
  right,
  left,
  gp_border = grid::gpar(fill = NA, col = "black", lwd = 12),
  name = NULL,
  gp = grid::gpar(),
  vp = NULL
)

grid.isocube(...)
}
\arguments{
\item{top}{A grid grob object to use as the top side of the cube.  ggplot2 objects will be coerced by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}}.}

\item{right}{A grid grob object to use as the right side of the cube.  ggplot2 objects will be coerced by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}}.}

\item{left}{A grid grob object to use as the left side of the cube.  ggplot2 objects will be coerced by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}}.}

\item{gp_border}{A \code{\link[grid:gpar]{grid::gpar()}} object for the \code{\link[=polygonGrob]{polygonGrob()}} used to draw borders around
the cube faces.}

\item{name}{A character identifier (for grid).}

\item{gp}{A \code{\link[grid:gpar]{grid::gpar()}} object.}

\item{vp}{A \code{\link[grid:viewport]{grid::viewport()}} object (or \code{NULL}).}

\item{...}{Passed to \code{isocubeGrob()}}
}
\value{
A \code{\link[grid:grid.grob]{grid::gTree()}} (grob) object of class "isocube".
As a side effect \code{grid.isocube()} draws to the active graphics device.
}
\description{
\code{isometricCube()} is a grid grob function to render
isometric cube faces by automatically wrapping around \code{affineGrob()}.
}
\details{
Any \code{ggplot2} objects are coerced to grobs by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}}.  Depending on what you'd like
to do you may want to instead manually convert a ggplot2 object \code{gg} to a grob with \code{gtable::gtable_filter(ggplot2::ggplotGrob(gg), "panel")}.
}
\examples{
if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
  # Only works if active graphics device supports affine transformations
  # such as `png(type="cairo")` on R 4.2+
  grid.newpage()
  gp_text <- gpar(fontsize = 72)
  grid.isocube(top = textGrob("top", gp = gp_text), 
               right = textGrob("right", gp = gp_text),
               left = textGrob("left", gp = gp_text))
}
if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
    colors <- c("#D55E00", "#009E73", "#56B4E9")
    spacings <- c(0.25, 0.2, 0.25)
    texts <- c("pkgname", "left\nface", "right\nface")
    rots <- c(45, 0, 0)
    fontsizes <- c(52, 80, 80)
    sides <- c("top", "left", "right")
    types <- gridpattern::names_polygon_tiling[c(5, 7, 9)]
    l_grobs <- list()
    grid.newpage()
    for (i in 1:3) {
        if (requireNamespace("gridpattern", quietly = TRUE)) {
            bg <- gridpattern::grid.pattern_polygon_tiling(
                       colour = "grey80",
                       fill = c(colors[i], "white"),
                       type = types[i],
                       spacing = spacings[i],
                       draw = FALSE)
        } else {
            bg <- rectGrob(gp = gpar(col = NA, fill = colors[i]))
        }
        text <- textGrob(texts[i], rot = rots[i],
                         gp = gpar(fontsize = fontsizes[i]))
        l_grobs[[sides[i]]] <- grobTree(bg, text)
    }
  grid.newpage()
  grid.isocube(top = l_grobs$top, 
               right = l_grobs$right,
               left = l_grobs$left)
}
}
