% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metrics.R
\name{aw_get_metrics}
\alias{aw_get_metrics}
\title{Get list of metrics}
\usage{
aw_get_metrics(
  rsid = Sys.getenv("AW_REPORTSUITE_ID"),
  locale = "en_US",
  segmentable = "NULL",
  expansion = NULL,
  company_id = Sys.getenv("AW_COMPANY_ID"),
  debug = FALSE,
  use_oob
)
}
\arguments{
\item{rsid}{Adobe report suite ID (RSID).  If an environment variable called \code{AW_REPORTSUITE_ID} exists
in \code{.Renviron} or elsewhere and no \code{rsid} argument is provided, then the \code{AW_REPORTSUITE_ID} value will
be used. Use \code{\link{aw_get_reportsuites}} to get a list of available \code{rsid} values.}

\item{locale}{The locale that system-named metrics should be returned in. Non-localized values will
be returned for title, name, description, etc. if a localized value is not available.}

\item{segmentable}{Boolean that determines whether or not to include metrics that can be used in
segments. \code{NULL} (the default) and \code{FALSE} return \emph{all} metrics (\emph{not} just the non-segmentable ones).
Examples of metrics that cannot be used in segments are \code{bounces}, \verb{bounce rate}, \code{entries}, and \code{visitors}.}

\item{expansion}{Additional metrics metadata to include in the results: \code{tags}, \code{allowedForReporting},
and \code{categories}. This argument takes a single value (e.g., \code{expansion = "tags"}) or a vector  of
values (e.g., \code{expansion = c("tags", "categories")}).}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link{get_me}} to get a list of available \code{company_id} values.}

\item{debug}{Include the output and input of the api call in the console for debugging. Default is FALSE}

\item{use_oob}{Always set to TRUE. Needed for tests}
}
\value{
A data frame of metrics (excluding calculated metrics) and their meta data.
}
\description{
Get a data frame with all of the standard (non-calculated) metrics (measures) in the report suite.
}
\details{
This function is commonly used to get the correct ID for a specific metric or metrics that will be used in
other function calls. The results returned are:
\itemize{
\item All of the "out of the box" metrics like visits, page views, visitors, orders, revenue, bounce rate, etc.
\item All of the enabled events that are configured in the report suite.
\item An instances metric for each enabled eVar.
}

This function does \emph{not} return calculated metrics.
}
\seealso{
\code{\link{aw_get_calculatedmetrics}}
}
