% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix-package.R
\docType{package}
\name{admix-package}
\alias{admix}
\alias{admix-package}
\title{admix: Package Admix for Admixture (aka Contamination) Models}
\description{
Implements several methods to estimate the unknown quantities related 
    to two-component admixture models, where the two components can belong to any
    distribution (note that in the case of multinomial mixtures, the two components
    must belong to the same family). Estimation methods depend on the assumptions 
    made on the unknown component density (see Bordes and Vandekerkhove (2010) <doi:10.3103/S1066530710010023>; 
    Patra and Sen (2016) <doi:10.1111/rssb.12148>); Milhaud, Pommeret, Salhi and Vandekerkhove 
    (2021) <doi:10.1016/j.jspi.2021.05.010>). In practice, one can estimate both the 
    mixture weight and the unknown component density in a wide variety of frameworks.
    On top of that, hypothesis tests can be performed in one and two-samples contexts 
    to test the unknown component density. Finally, clustering of unknown
    mixture components is also feasible in a K-samples setting.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/XavierMilhaud/admix}
  \item Report bugs at \url{https://github.com/XavierMilhaud/admix/issues}
}

}
\author{
\strong{Maintainer}: Xavier Milhaud \email{xavier.milhaud.research@gmail.com}

Other contributors:
\itemize{
  \item Pierre Vandekerkhove [contributor]
  \item Denys Pommeret [contributor]
  \item Yahia Salhi [contributor]
}

}
\keyword{internal}
