% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_conn.R
\name{readBin}
\alias{readBin}
\alias{readBin.default}
\alias{readBin.adf_file_con}
\alias{readLines}
\alias{readLines.default}
\alias{readLines.adf_file_con}
\alias{writeBin}
\alias{writeBin.default}
\alias{writeBin.adf_file_con}
\alias{writeLines}
\alias{writeLines.default}
\alias{writeLines.adf_file_con}
\title{Transfer binary data to and from connections}
\usage{
readBin(
  con,
  what,
  n = 1L,
  size = NA_integer_,
  signed = TRUE,
  endian = .Platform$endian
)

\method{readBin}{default}(
  con,
  what,
  n = 1L,
  size = NA_integer_,
  signed = TRUE,
  endian = .Platform$endian
)

\method{readBin}{adf_file_con}(
  con,
  what,
  n = 1L,
  size = NA_integer_,
  signed = TRUE,
  endian = .Platform$endian
)

readLines(
  con,
  n = -1L,
  ok = TRUE,
  warn = TRUE,
  encoding = "unknown",
  skipNul = FALSE
)

\method{readLines}{default}(
  con = stdin(),
  n = -1L,
  ok = TRUE,
  warn = TRUE,
  encoding = "unknown",
  skipNul = FALSE
)

\method{readLines}{adf_file_con}(
  con,
  n = -1L,
  ok = TRUE,
  warn = TRUE,
  encoding = "unknown",
  skipNul = FALSE
)

writeBin(
  object,
  con,
  size = NA_integer_,
  endian = .Platform$endian,
  useBytes = FALSE
)

\method{writeBin}{default}(
  object,
  con,
  size = NA_integer_,
  endian = .Platform$endian,
  useBytes = FALSE
)

\method{writeBin}{adf_file_con}(
  object,
  con,
  size = NA_integer_,
  endian = .Platform$endian,
  useBytes = FALSE
)

writeLines(text, con, sep = "\\n", useBytes = FALSE)

\method{writeLines}{default}(text, con = stdout(), sep = "\\n", useBytes = FALSE)

\method{writeLines}{adf_file_con}(text, con = stdout(), sep = "\\n", useBytes = FALSE)
}
\arguments{
\item{con}{A connection to a file on a virtual ADF device. Such a connection can
be established with \code{adf_file_con()}.}

\item{what}{Either an object whose mode will give the mode of the
    vector to be read, or a character vector of length one describing
    the mode: one of \code{"numeric"}, \code{"double"},
    \code{"integer"}, \code{"int"}, \code{"logical"}, \code{"complex"},
    \code{"character"}, \code{"raw"}.}

\item{n}{numeric.  The (maximal) number of records to be
    read.  You can use an over-estimate here, but not too large as
    storage is reserved for \code{n} items.}

\item{size}{integer.  The number of bytes per element in the byte
    stream.  The default, \code{NA_integer_}, uses the natural size.
    Size changing is not supported for raw and complex vectors.}

\item{signed}{logical.  Only used for integers of sizes 1 and 2,
    when it determines if the quantity on file
    should be regarded as a signed or unsigned integer.}

\item{endian}{The endian-ness (\code{"big"} or \code{"little"}) of the
    target system for the file.  Using \code{"swap"} will force swapping
    endian-ness.}

\item{ok}{logical.  Is it OK to reach the end of the connection before
    \code{n > 0} lines are read?  If not, an error will be generated.}

\item{warn}{logical.  Warn if a text file is missing a final EOL or if
    there are embedded nuls in the file.}

\item{encoding}{encoding to be assumed for input strings.  It is
    used to mark character strings as known to be in
    Latin-1, UTF-8 or to be bytes: it is not used to re-encode the input.
    To do the
    latter, specify the encoding as part of the connection \code{con} or
    via \code{\link[base]{options}(encoding=)}: see the examples
    and \sQuote{Details}.
  }

\item{skipNul}{logical: should nuls be skipped?}

\item{object}{An \R object to be written to the connection.}

\item{useBytes}{See \code{\link[base]{writeLines}}.}

\item{text}{A character vector}

\item{sep}{character string.  A string to be written to the connection
    after each line of text.}
}
\value{
Returns \code{NULL} invisibly
}
\description{
These methods mask the identical functions in the \code{base} package (see \code{\link[base:readBin]{base::readBin()}},
\code{\link[base:readLines]{base::readLines()}}, \code{\link[base:readChar]{base::readChar()}}, \code{\link[base:readBin]{base::writeBin()}}, \code{\link[base:writeLines]{base::writeLines()}} and
\code{\link[base:readChar]{base::writeChar()}}. They behave exactly the
same as their base counterpart, with the exception that they can read and write to connections
opened with \code{adf_file_con()}.
}
