% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01genericSupport.r
\name{rawToBitmap}
\alias{rawToBitmap}
\alias{bitmapToRaw}
\title{Convert raw data into a bitmap or vice versa}
\usage{
rawToBitmap(x, invert.bytes = F, invert.longs = T)

bitmapToRaw(x, invert.bytes = T, invert.longs = T)
}
\arguments{
\item{x}{A \code{vector} of \code{raw} data, in case
\code{rawToBitmap} is used. A \code{vector} of \code{raw},
\code{interger} or \code{logical} values should be used in
case of \code{bitmapToRaw}. In the latter case each value in the
\code{vector} is interpreted as a bit and should be a multiple of
8 long.}

\item{invert.bytes}{A \code{logical} value. When set to \code{TRUE},
the bit order of bytes are reversed.}

\item{invert.longs}{A \code{logical} value. When set to \code{TRUE},
the bit order of long values (32 bits) are reversed. When \code{x}
does not have a multiple length of 32 bits or 4 bytes, \code{x} will
be padded with zeros to the right, but the result will be trimmed to
correspond with the length of \code{x}. Note that data might get lost
this way.}
}
\value{
Returns a \code{vector} of \code{raw} data in case of
\code{bitmapToRaw}, and a \code{vector} of binary \code{raw} values
in case of \code{rawToBitmap}.
}
\description{
Convert raw data into a bitmap or vice versa (i.e., binary data)
conform Amiga specifications.
}
\details{
A bitmap is simply put a map of bits (binary data, which can
be interpeted as 0 or 1; or FALSE and TRUE). Bitmaps can have
several purposes, also on the Commodore Amiga. The Amiga file
system uses a bitmap to indicates which blocks are occupied with
data and which are free. Bitmaps can also be used in bitmap images
where each bit indicates which color should be used for a specific
pixel in an image. These function can be used to convert raw data
into usable bitmaps or vice versa.

As the Commodore Amiga is a big-endian system (most significant
bit first) using a 32 bit CPU, it may sometimes necessary to invert
the bits of a byte or longs (4 bytes, 32 bits), which can be done
with the arguments '\code{invert.bytes}' and '\code{invert.longs}'
respectively.
}
\examples{
## The bitmap block of the example disk is located at block
## number 882 (note that this is not true for all disks,
## the actual location is stored in the root block)
data(adf.example)
bitmap.block <- amigaBlock(adf.example, 881)

## bitmap data are stored in bytes 5 up to 224 in this block:
bitmap.raw <- bitmap.block@data[5:224]

## let's get the bitmap from the raw data:
bitmap <- rawToBitmap(bitmap.raw)

## Whe can now get the occupied blocks (minus one is used for
## the discrepancy in indexing):
which(bitmap != as.raw(0x01)) - 1

## we can also do the reverse:
bitmap.raw.new <-  bitmapToRaw(bitmap)
## it should be the same as the original raw data:
all(bitmap.raw.new == bitmap.raw)

## WARNING: don't use these methods to directly
## modify an amigaDisk objects bitmap block. The
## file system on that object may get corrupted.
## All methods in this package should update the
## bitmap block automatically and cleanly...
}
\seealso{
Other raw.operations: 
\code{\link{amigaDateToRaw}()},
\code{\link{amigaIntToRaw}()},
\code{\link{displayRawData}()},
\code{\link{rawToAmigaDate}()},
\code{\link{rawToAmigaInt}()}
}
\author{
Pepijn de Vries
}
\concept{raw.operations}
