% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02amigaDiskBasics.r
\docType{methods}
\name{list.adf.files}
\alias{list.adf.files}
\alias{list.adf.files,amigaDisk,missing-method}
\alias{list.adf.files,amigaDisk,character-method}
\title{List files in an amigaDisk directory}
\usage{
\S4method{list.adf.files}{amigaDisk,missing}(x, path)

\S4method{list.adf.files}{amigaDisk,character}(x, path)
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} object for which the files
should be listed.}

\item{path}{Specify the path on the \code{\link{amigaDisk}}
object, conform Amiga specs, for which files should be listed.
See \code{\link{current.adf.dir}} for details on these specs.}
}
\value{
Returns a \code{vector} of \code{character}s listing
the files in the specified directory on the virtual disk.
}
\description{
Get a list of files in a specific directory on a virtual
\code{\link{amigaDisk}}.
}
\details{
As an analogue of \code{\link[base]{list.files}}, this method
list files in a specific directory. But in this case the files
are located on a virtual floppy disk represented by the
\code{\link{amigaDisk}} object. This works only for DOS-formatted
(\code{\link{is.amigaDOS}}) virtual disks.
}
\examples{
data(adf.example)

## show all files in the root of the example
## disk file:
list.adf.files(adf.example)

## you can also list the files in a specified
## directory:
list.adf.files(adf.example, "DF0:mods")

## For the same path, only now specified
## relatively to the current directory:
list.adf.files(adf.example, "mods")

}
\author{
Pepijn de Vries
}
