% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adea.R
\name{adea}
\alias{adea}
\title{ADEA analysis to variable selection in DEA}
\usage{
adea(
  input,
  output,
  orientation = c("input", "output"),
  load.orientation = c("inoutput", "input", "output"),
  name = "",
  eff.tolerance = 0.001
)
}
\arguments{
\item{input}{A matrix or a data frame with the inputs of units to be evaluated, one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame with the outputs of units to be evaluated, one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or use "output" for output orientation in DEA model.}

\item{load.orientation}{It allows the selection of variables to be included in load analysis.
Its default value is "inoutput" which means that all input and all output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}

\item{name}{An optional descriptive name for the model. It will be shown in print and summary results.}

\item{eff.tolerance}{A value between 0 and 1 to tolerance when considering a DMU as efficient in reports.}
}
\value{
The function return an adea class object with the following named members:
\itemize{
\item eff is a vector with DMU's scores
\item neff is the number of efficient DMU with eff.tolerance. It means DMUs with efficiencies between 1 - eff.tolerance and 1 + eff.tolerance.
\item load.orientation is the load orientation, one of 'input', 'output' or 'inoutput'. The last is the default value.
\item name: A label of the model
\item orientation: DEA model orientation 'input' or 'output'
\item ux: A set of weights for inputs
\item vy: A set of weights for output
\item load: A list with all information about loads:
  \itemize{
    \item ratios$input: A vector with load ratios of input variables
    \item ratios$output: A vector with load ratios of output variables
    \item load: The lowest load ratio, which is the load of the ADEA model
    \item lp: A pointer to the linear programming program of the model. Mainly for research purpose
    \item iinput: A vector of index of inputs that almost reach the load level
    \item ioutput: A vector of index of outputs that almost reach the load level
  }
}
}
\description{
ADEA analysis, computes a score for each DMU and load ratio for each variable.
}
\details{
This function computes an efficiency score for each DMU, the same as in standard DEA model.

Then a load ratio for each variable is computed searching two new set of weights while keeping DMU's scores.

The load ratio of a variable is a number between 0 and 1.
Where 0 means that the contribution of that variable to the efficiency computations is negligible.
In an ideal case, each input or output variable will have a load of 1 divide by the number of them.

As it is usually done in DEA this load ratio has been computed as its maximum allowable value.
But because the sum of all of them is 1, when one increases its load ratio any other decreases its value.
So only the lowest value of all load ratios, this is load model, has a real meaning.
This lowest value can be taken as a significance measure of the entire model.
}
\examples{
data('cardealers4')
input <- cardealers4[, 1:2]
output <- cardealers4[, 3:4]

# Compute adea model
model <- adea(input, output)
model
# Dealer A  Dealer B  Dealer C  Dealer D  Dealer E  Dealer F
# 0.9915929 1.0000000 0.8928571 0.8653846 1.0000000 0.6515044

# Get model's load
model$load$load
# [1] 0.6666667

# Get model's load ratios
model$load$ratios
# $input
# Employees Depreciation
# 0.6666667    1.3333333
# $output
# CarsSold WorkOrders
# 1.2663476  0.7336524 

}
\seealso{
\code{\link{adea-package}}.
}
