% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expose.R
\name{expose}
\alias{expose}
\alias{expose_py}
\alias{expose_pq}
\alias{expose_pm}
\alias{expose_pw}
\alias{expose_cy}
\alias{expose_cq}
\alias{expose_cm}
\alias{expose_cw}
\title{Create exposure records from census records}
\usage{
expose(
  .data,
  end_date,
  start_date = as.Date("1900-01-01"),
  target_status = NULL,
  cal_expo = FALSE,
  expo_length = c("year", "quarter", "month", "week"),
  col_pol_num = "pol_num",
  col_status = "status",
  col_issue_date = "issue_date",
  col_term_date = "term_date",
  default_status
)

expose_py(...)

expose_pq(...)

expose_pm(...)

expose_pw(...)

expose_cy(...)

expose_cq(...)

expose_cm(...)

expose_cw(...)
}
\arguments{
\item{.data}{A data frame with census-level records}

\item{end_date}{Experience study end date}

\item{start_date}{Experience study start date. Default value = 1900-01-01.}

\item{target_status}{Character vector of target status values. Default value
= \code{NULL}.}

\item{cal_expo}{Set to TRUE for calendar year exposures. Otherwise policy
year exposures are assumed.}

\item{expo_length}{Exposure period length}

\item{col_pol_num}{Name of the column in \code{.data} containing the policy number}

\item{col_status}{Name of the column in \code{.data} containing the policy status}

\item{col_issue_date}{Name of the column in \code{.data} containing the issue date}

\item{col_term_date}{Name of the column in \code{.data} containing the termination
date}

\item{default_status}{Optional scalar character representing the default
active status code. If not provided, the most common status is assumed.}

\item{...}{Arguments passed to \code{expose()}}
}
\value{
A tibble with class \code{exposed_df}, \code{tbl_df}, \code{tbl},
and \code{data.frame}. The results include all existing columns in
\code{.data} plus new columns for exposures and observation periods. Observation
periods include counters for policy exposures, start dates, and end dates.
Both start dates and end dates are inclusive bounds.

For policy year exposures, two observation period columns are returned.
Columns beginning with (\code{pol_}) are integer policy periods. Columns
beginning with (\code{pol_date_}) are calendar dates representing
anniversary dates, monthiversary dates, etc.
}
\description{
Convert a data frame of census-level records to exposure-level
records.
}
\details{
Census-level data refers to a data set wherein there is one row
per unique policy. Exposure-level data expands census-level data such that
there is one record per policy per observation period. Observation periods
could be any meaningful period of time such as a policy year, policy month,
calendar year, calendar quarter, calendar month, etc.

\code{target_status} is used in the calculation of exposures. The annual
exposure method is applied, which allocates a full period of exposure for
any statuses in \code{target_status}. For all other statuses, new entrants
and exits are partially exposed based on the time elapsed in the observation
period. This method is consistent with the Balducci Hypothesis, which assumes
that the probability of termination is proportionate to the time elapsed
in the observation period. If the annual exposure method isn't desired,
\code{target_status} can be ignored. In this case, partial exposures are
always applied regardless of status.

\code{default_status} is used to indicate the default active status that
should be used when exposure records are created.
}
\section{Policy period and calendar period variations}{
The functions \code{expose_py()}, \code{expose_pq()}, \code{expose_pm()},
\code{expose_pw()}, \code{expose_cy()}, \code{expose_cq()},
\code{expose_cm()}, \code{expose_cw()} are convenience functions for
specific implementations of \code{expose()}. The two characters after the
underscore describe the exposure type and exposure period, respectively.

For exposures types:
\itemize{
\item \code{p} refers to policy years
\item \code{c} refers to calendar years
}

For exposure periods:
\itemize{
\item \code{y} = years
\item \code{q} = quarters
\item \code{m} = months
\item \code{w} = weeks
}
}

\examples{
toy_census |> expose("2020-12-31")

census_dat |> expose_py("2019-12-31", target_status = "Surrender")

}
\references{
Atkinson and McGarry (2016). Experience Study Calculations.
\url{https://www.soa.org/49378a/globalassets/assets/files/research/experience-study-calculations.pdf}
}
\seealso{
\code{\link[=expose_split]{expose_split()}} for information on splitting calendar year
exposures by policy year.
}
