% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{autotable}
\alias{autotable}
\alias{autotable.exp_df}
\alias{autotable.trx_df}
\title{Tabular experience study summary}
\usage{
autotable(object, ...)

\method{autotable}{exp_df}(
  object,
  fontsize = 100,
  decimals = 1,
  colorful = TRUE,
  color_q_obs = "RColorBrewer::GnBu",
  color_ae_ = "RColorBrewer::RdBu",
  rename_cols = rlang::list2(...),
  show_conf_int = FALSE,
  show_cred_adj = FALSE,
  decimals_amt = 0,
  suffix_amt = FALSE,
  ...
)

\method{autotable}{trx_df}(
  object,
  fontsize = 100,
  decimals = 1,
  colorful = TRUE,
  color_util = "RColorBrewer::GnBu",
  color_pct_of = "RColorBrewer::RdBu",
  rename_cols = rlang::list2(...),
  show_conf_int = FALSE,
  decimals_amt = 0,
  suffix_amt = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{exp_df} usually created by the
function \code{\link[=exp_stats]{exp_stats()}} or an object of class \code{trx_df} created by the
\code{\link[=trx_stats]{trx_stats()}} function.}

\item{...}{Additional arguments passed to \code{\link[gt:gt]{gt::gt()}}.}

\item{fontsize}{Font size percentage multiplier.}

\item{decimals}{Number of decimals to display for percentages}

\item{colorful}{If \code{TRUE}, color will be added to the the observed
termination rate and actual-to-expected columns for termination studies, and
the utilization rate and "percentage of" columns for transaction studies.}

\item{color_q_obs}{Color palette used for the observed termination rate.}

\item{color_ae_}{Color palette used for actual-to-expected rates.}

\item{rename_cols}{An optional list consisting of key-value pairs. This
can be used to relabel columns on the output table. This parameter is most
useful for renaming grouping variables that will appear under their original
variable names if left unchanged. See \code{\link[gt:cols_label]{gt::cols_label()}} for more
information.}

\item{show_conf_int}{If \code{TRUE} confidence intervals will be displayed
assuming they are available on \code{object}.}

\item{show_cred_adj}{If \code{TRUE} credibility-weighted termination rates will
be displayed assuming they are available on \code{object}.}

\item{decimals_amt}{Number of decimals to display for amount columns (number
of claims, claim amounts, exposures, transaction counts, total transactions,
and average transactions)}

\item{suffix_amt}{This argument has the same meaning as the \code{suffixing}
argument in \code{\link[gt:fmt_number]{gt::fmt_number()}} for amount columns. If \code{FALSE} (the default),
no scaling or suffixing are applied to amount columns. If \code{TRUE}, all amount
columns are automatically scaled and suffixed by "K" (thousands), "M"
(millions), "B" (billions), or "T" (trillions). See \code{\link[gt:fmt_number]{gt::fmt_number()}} for
more information.}

\item{color_util}{Color palette used for utilization rates.}

\item{color_pct_of}{Color palette used for "percentage of" columns.}
}
\value{
a \code{gt} object
}
\description{
\code{autotable()} is a generic function used to create a table
from an object of a particular class. Tables are constructed using the
\code{gt} package.

\code{autotable.exp_df()} is used to convert experience study results to a
presentation-friendly format.

\code{autotable.trx_df()} is used to convert transaction study results to a
presentation-friendly format.
}
\details{
The \code{color_q_obs}, \code{color_ae_}, \code{color_util}, and \code{color_pct_of} arguments
must be strings referencing a discrete color palette available in the
\code{paletteer} package. Palettes must be in the form "package::palette".
For a full list of available palettes, see \link[paletteer:palettes_d_names]{paletteer::palettes_d_names}.
}
\examples{

if (interactive()) {
  study_py <- expose_py(census_dat, "2019-12-31", target_status = "Surrender")
  expected_table <- c(seq(0.005, 0.03, length.out = 10), 0.2, 0.15, rep(0.05, 3))

  study_py <- study_py |>
    mutate(expected_1 = expected_table[pol_yr],
           expected_2 = ifelse(inc_guar, 0.015, 0.03)) |>
    add_transactions(withdrawals) |>
    left_join(account_vals, by = c("pol_num", "pol_date_yr"))

  exp_res <- study_py |> group_by(pol_yr) |>
    exp_stats(expected = c("expected_1", "expected_2"), credibility = TRUE,
              conf_int = TRUE)
  autotable(exp_res)

  trx_res <- study_py |> group_by(pol_yr) |>
    trx_stats(percent_of = "av_anniv", conf_int = TRUE)
  autotable(trx_res)
}

}
