% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkGUI}
\alias{checkGUI}
\title{Check if the dependencies required to open a GUI are installed, and if
opening a GUI does not throw an error. Some code adapted from RGtk2's
.onLoad function.}
\usage{
checkGUI(GUI = c("needed", "always", "never"))
}
\arguments{
\item{GUI}{One of "needed", "always" or "never". If "needed", a new window is
opened to inspect the movements only when the movements table is too big to be
displayed in R's console. If "always", a graphical interface is always created
when the possibility to invalidate events emerges. If "never", a graphical
interface is never invoked. In this case, if the table to be displayed does
not fit in R's console, a temporary file will be saved and the user will be
prompted to open that file and examine it. Defaults to "needed".}
}
\value{
An updated GUI argument (character string)
}
\description{
Check if the dependencies required to open a GUI are installed, and if
opening a GUI does not throw an error. Some code adapted from RGtk2's
.onLoad function.
}
\keyword{internal}
