% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_transcript_fulltext.R
\name{search_transcript_fulltext}
\alias{search_transcript_fulltext}
\title{Search in full text of a single transcript}
\usage{
search_transcript_fulltext(t, s)
}
\arguments{
\item{t}{Transcript object; transcript to search in.}

\item{s}{Search object.}
}
\value{
\code{Data.frame} data frame with search results.
}
\description{
Search in full text of a single transcript
}
\examples{
library(act)

# Search for the 1. Person Singular Pronoun in Spanish.
# Only create the search object without running the search.
mysearch <- act::search_new(x=examplecorpus, pattern= "yo", runSearch=FALSE)

# Run the search
df <- act::search_transcript_fulltext(t=examplecorpus@transcripts[[3]],
                                      s=mysearch)
nrow(df)
}
