% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_merge.R
\name{transcripts_merge}
\alias{transcripts_merge}
\title{Merge several transcripts}
\usage{
transcripts_merge(
  x,
  destinationTranscriptName,
  updateTranscriptNames,
  identifierTier = "update",
  identifierPattern = ".+",
  eraseUpdateSectionsCompletely = TRUE
)
}
\arguments{
\item{x}{Corpus object;}

\item{destinationTranscriptName}{Character strings; name of transcript hat willl be updated.}

\item{updateTranscriptNames}{Vector of character strings; names of transcripts that contain the updates.}

\item{identifierTier}{Character string;  regular expression that identifies the tier in which the sections are marked, that will be inserted into transDestination.}

\item{identifierPattern}{Character string; regular expression that identifies the sections that will be inserted into transDestination.}

\item{eraseUpdateSectionsCompletely}{Logical; if \code{TRUE} update sections in destination transcript will be erased completely, if \code{FALSE} update sections in the destination tier will not be erased completely but only the tiers that are present in the transUpdates be erased.}
}
\value{
Transcript object
}
\description{
Merges several transcript objects in a corpus object.
One transcript is the destination transcript (the transcript that will be updated and receives the new data). 
The other transcripts are the update transcripts (they contain the data that will replace data in teh destination transcript). 
The update transcripts need to contain a tier in which the update sections are marked with a specific character string.
}
\details{
You may chose between the following two options:
- The update sections in the destination transcript will first be erased completely and then the updates will be filled in.
- The update sections in the destination transcript will NOT be erased completely. Rater only the contents of tiers will be erased that are also present in the update tiers. e.g. if your destination transcript contains more tiers than the update transcripts, the contents of those tiers will be preserved in the destination tier during the update.
}
\examples{
library(act)

# We need three transcripts  to demonstrate the function \code{transcripts_merge}:
# - the destination transcript: "update_destination"
# - two transcripts that contain updates: "update_update1 and "update_update2"

#Have a look at the annotations in the destination transcript first. 
#It contains 2 annotations:
examplecorpus@transcripts[["update_destination"]]@annotations
#Have a look at the annotations in the update_update1 transcript, too: 
#It contains 3 annotations:
examplecorpus@transcripts[["update_update1"]]@annotations

# Run the function with only one update:
test <- act::transcripts_merge(x=examplecorpus,
   destinationTranscriptName="update_destination", 
   updateTranscriptNames = "update_update1")

#Have a look at the annotations in the destination transcript again.
#It now contains 5 annotations:
test@transcripts[["update_destination"]]@annotations


# Run the function with two transcript objects for updates:
test <- act::transcripts_merge(x=examplecorpus,
	destinationTranscriptName="update_destination", 
	updateTranscriptNames = c("update_update1","update_update2"))

#Have a look at the annotations in the destination transcript again.
#It now contains 8 annotations:
test@transcripts[["update_destination"]]@annotations

# Compare the transcript in the original and in the modified corpus object. 
# The update transcript objects are gone:
act::info_summarized(examplecorpus)$transcripts.names
act::info_summarized(test)$transcripts.names
	
#Have a look at the history of the corpus object
test@history
}
\seealso{
\link{transcripts_merge2}
}
