% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiers_convert.R
\name{tiers_convert}
\alias{tiers_convert}
\title{Convert tiers}
\usage{
tiers_convert(
  x,
  intervalToPoint = FALSE,
  pointToInterval = FALSE,
  filterTierNames = NULL,
  filterTranscriptNames = NULL
)
}
\arguments{
\item{x}{Corpus object.}

\item{intervalToPoint}{Logical; if \code{TRUE} interval tiers will be converted to point/text tiers.}

\item{pointToInterval}{Logical; if \code{TRUE} point/text tiers will be converted to interval tiers.}

\item{filterTierNames}{Vector of character strings; names of the tiers to be included.}

\item{filterTranscriptNames}{Vector of character strings; names of the transcripts to be checked. If left open, all transcripts will be checked}
}
\value{
Corpus object.
}
\description{
Converts tier types between 'interval' and 'point' tier.  
Applies to all tiers in all transcript objects of a corpus.
If only certain transcripts or tiers should be affected set the parameter \code{filterTranscriptNames}. 
In case that you want to select transcripts by using regular expressions use the function \code{act::search_meta} first.
}
\details{
Note: When converting from interval > point tier, the original end times of the annotations will be lost definitely.
}
\examples{
library(act)

# Check the names and types of the existing tiers in the first two transcripts
examplecorpus@transcripts[[1]]@tiers
examplecorpus@transcripts[[2]]@tiers

# Convert interval tiers to point tiers
newcorpus <- act::tiers_convert(examplecorpus, intervalToPoint=TRUE)

# the names and types of the existing tiers
newcorpus@transcripts[[1]]@tiers
newcorpus@transcripts[[2]]@tiers

# Convert point tiers to interval tiers
newcorpus <- act::tiers_convert(newcorpus, pointToInterval=TRUE)

# Note: In this round trip conversion from 'interval > point > interval tier' 
# the original end times of the annotations get lost (when converting from interval > point).
}
\seealso{
\link{tiers_add}, \link{tiers_delete}, \link{tiers_rename}, \link{tiers_sort}, \link{helper_tiers_new_table}, \link{helper_tiers_sort_table}
}
