% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_data_matrix.R
\name{modify_data_matrix}
\alias{modify_data_matrix}
\title{Search and replace contents of annotations using a matrix}
\usage{
modify_data_matrix(x, path_replacementMatrixCSV, showProgress = TRUE)
}
\arguments{
\item{x}{Corpus object.}

\item{path_replacementMatrixCSV}{Character string; path to replacement matrix (a CSV file).}

\item{showProgress}{Logical; if \code{TRUE} the progress bar will be displayed.}
}
\value{
Corpus object.
}
\description{
This functions performs a search and replace in the contents of an annotation. 
A simple matrix consisting of two columns will be used. 
The first column of the matrix needs to contain the search string, the second column  the replacement string.
The matrix needs to be in CSV format.
}
\examples{
library(act)

# An example replacement matrix comes with the package.
# It replaces most of the GAT conventions.
path <- system.file("extdata", "normalization", "normalizationMatrix.csv", package="act")

# Have a look at the matrix
mymatrix <- act::matrix_load(path)
mymatrix

# Apply matrix to examplecorpus
test <- act::modify_data_matrix(x=examplecorpus, path_replacementMatrixCSV=path)

# Compare some annotations in the original examplecorpus object and
# in the modified corpus object test
examplecorpus@transcripts[[1]]@data$content[[1]]
test@transcripts[[1]]@data$content[[1]]

examplecorpus@transcripts[[2]]@data$content[[3]]
test@transcripts[[2]]@data$content[[3]]
}
\seealso{
[matrix_load()] for loading the matrix 
and [matrix_save()] for saving the matrix to a CSV file.

\link{media_remove}, \link{media_getpath}
}
