% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callsnvs.R
\name{callsnvs}
\alias{callsnvs}
\title{Call somatic SNVs by using both global and local error models}
\usage{
callsnvs(sample.info.file, outdir, targetbed,
  pbem_dir = file.path(outdir, "BaseErrorModel"),
  controls_dir = file.path(outdir, "Controls"), pacbamfolder_bychrom,
  detection.specificity = 0.995, replicas = 1000,
  replicas.in.parallel = 1, coeffvar.threshold = 0.01,
  AFbycov = TRUE, mincov = 10, mincovgerm = 10, minalt = 1,
  maxafgerm = 0.2, coverage_binning = 50,
  outdir.calls.name = "Results", chrom.in.parallel = 1)
}
\arguments{
\item{sample.info.file}{The sample info file listing CASE and CONTROL samples. The format is simply 5 columns, tab-delimited, and there is no column header.}

\item{outdir}{The folder where outputs will be saved.}

\item{targetbed}{Genomic regions in the BED tab-delimited format.}

\item{pbem_dir}{The folder with outputs generated by the \code{compute_pbem} function. default: file.path(outdir, "BaseErrorModel")}

\item{controls_dir}{The folder with outputs generated by the \code{compute_afthreshold} function. default: file.path(outdir, "Controls")}

\item{pacbamfolder_bychrom}{The folder popluted by outputs by the \code{split_pacbam_bychrom} function.}

\item{detection.specificity}{The quantile of the GSE distribution(s) to use to compute the AF threhold. default: 0.995}

\item{replicas}{Replics sampling to define stability of AF threhold in bins of coverage. default: 1000}

\item{replicas.in.parallel}{default: 1}

\item{coeffvar.threshold}{Consider a bin as stable if the coefficient of variations after \code{replicas} is lower than the \code{coeffvar.threshold}. default: 0.01}

\item{AFbycov}{Apply coverage-based AF threhold. default: TRUE}

\item{mincov}{Minimum locus coverage in CASE sample. default: 10}

\item{mincovgerm}{Minimum locus coverage in CONTROL sample. default: 10}

\item{minalt}{Minimum number of reads supporting the alternative allele in CASE sample. default: 1}

\item{maxafgerm}{Maximum allelic fraction observed in matched CONTROL locus. default: 0.2}

\item{coverage_binning}{Bins of coverage into which divide AFs. default: 50}

\item{outdir.calls.name}{The subfolder name that will be created in the \code{outdir}. default: "Results"}

\item{chrom.in.parallel}{Number of chromosomes to run in parallel. default: 1}
}
\value{
The \code{callsnvs} will create a subfolder for each CASE sample within the \code{outdir.calls.name} folder. There tab-delimeted files reporting SNV calls passing 3 consecutive filtering steps (\code{pmtab_F1}, \code{pmtab_F2} and \code{pmtab_F3}) are saved.

The function also return the data.frame \code{tabsnvs_index} reeporting for each sample the path to each of the tables generated during the 3 filtering steps.
}
\description{
Call somatic SNVs by using both global and local error models
}
\examples{
sample.info.file <- system.file("extdata", "test_sif_toy.tsv", package = "abemus")
outdir <- tempdir()
targetbed <- system.file("extdata", "regions_toy.bed", package = "abemus")
pacbamfolder_bychrom <- system.file("extdata", "pacbam_data_bychrom", package = "abemus")
pbem_dir <- system.file("extdata", "BaseErrorModel", package = "abemus")
controls_dir <- system.file("extdata", "Controls", package = "abemus")
callsnvs(sample.info.file,outdir,targetbed,pbem_dir,controls_dir,pacbamfolder_bychrom,replicas=1)
}
