% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{CichlidsGnRH}
\alias{CichlidsGnRH}
\title{GnRH Levels in Cichlids}
\format{A data frame with 11 observations on the following 2 variables.
\describe{ \item{territorial}{a factor with levels \code{No} and
\code{Yes}} \item{GnRH.mRNA}{a numeric vector} }}
\source{
White, S.A., T. Nguyen, and R.D. Fernald. 2002. Social regulation of
gonadotropin-releasing hormone. \emph{Journal of Experimental Biology} 205:
2567-2581.
}
\description{
Levels of mRNA for gonadotropin-releasing hormone in cichlids
(\emph{Haplochromis burtoni}) that are (\emph{n} = 5) and are not (\emph{n}
= 6) territorial.
}
\examples{
xyplot(GnRH.mRNA ~ territorial, CichlidsGnRH, type=c('p','a'))
}
\references{
\url{http://jeb.biologists.org/cgi/content/abstract/205/17/2567}
}
\keyword{datasets}

