#' simple interactive network diagram of correlated substitution pairs 
#'
#' @param corSubDF A data frame with two columns i.e. Pos1 and Pos2. This file is generated by 'getTopSub' function.
#'
#' @return An interactive network diagram of correlated substitution pairs. 
#' @export
#' @import plotly
#' @importFrom magrittr %>% 
#' @examples
#' corSub <- corSubFile
#' plotCorNet(corSubDF = corSub)



plotCorNet <- function(corSubDF){
  networkD3::simpleNetwork(corSubDF, fontSize = 12, fontFamily = "sans-serif", zoom = TRUE)
}