% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_petri.R
\name{canvas_petri}
\alias{canvas_petri}
\title{Draw Petri Dish Colonies}
\usage{
canvas_petri(
  colors,
  background = "#fafafa",
  dish = "black",
  attractors = 1000,
  iterations = 15,
  hole = 0
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background (and the hole).}

\item{dish}{a character specifying the color used for the Petri dish.}

\item{attractors}{an integer specifying the number of attractors.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{hole}{a value between 0 and 0.9 specifying the hole size in proportion to the dish.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function uses a space colony algorithm to draw Petri dish colonies.
}
\examples{
\donttest{
set.seed(2)

# Simple example
canvas_petri(colors = colorPalette("origami"))

# Advanced example
canvas_petri(colors = "white", hole = 0.8, attractors = 5000)
}

}
\references{
\url{https://medium.com/@jason.webb/space-colonization-algorithm-in-javascript-6f683b743dc5}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
