% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_circlemap.R
\name{canvas_circlemap}
\alias{canvas_circlemap}
\title{Paint a Circle Map on a Canvas}
\usage{
canvas_circlemap(colors, xmin = 0, xmax = 12.56, ymin = 0, ymax = 1, 
                 iterations = 10, width = 1500, height = 1500)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{xmin}{a value specifying the minimum location on the x-axis.}

\item{xmax}{a value specifying the maximum location on the x-axis.}

\item{ymin}{a value specifying the minimum location on the y-axis.}

\item{ymax}{a value specifying the maximum location on the y-axis.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{width}{a positive integer specifying the width of the artwork in pixels.}

\item{height}{a positive integer specifying the height of the artwork in pixels.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws a circle map on the canvas.
}
\examples{
\donttest{
set.seed(3)
palette <- colorPalette('random', n = 5)
canvas_circlemap(colors = palette)
}

}
\references{
\url{https://en.wikipedia.org/wiki/Arnold_tongue}

\url{https://linas.org/art-gallery/circle-map/circle-map.html}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
