% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_blacklight.R
\name{canvas_blacklight}
\alias{canvas_blacklight}
\title{Paint Random Blacklights on a Canvas}
\usage{
canvas_blacklight(colors, n = 1000, resolution = 500)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{n}{a positive integer specifying the number of random data points to generate.}

\item{resolution}{a positive integer specifying the number of pixels (resolution x resolution) of the artwork.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function creates an artwork from randomly generated data by running a support vector machines regression algorithm to predict the color of each pixel on the canvas.
}
\examples{
\donttest{
set.seed(2)
palette <- colorPalette('random', n = 5)
canvas_blacklight(colors = palette)
}

}
\references{
\url{https://en.wikipedia.org/wiki/Support-vector_machine}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
