% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aMNLFA_object.R
\name{aMNLFA.object}
\alias{aMNLFA.object}
\title{aMNLFA object function}
\usage{
aMNLFA.object(
  dir,
  mrdata,
  indicators = NULL,
  catindicators = NULL,
  countindicators = NULL,
  meanimpact = NULL,
  varimpact = NULL,
  measinvar = NULL,
  factors = NULL,
  time = NULL,
  auxiliary = NULL,
  ID = NULL,
  thresholds = NULL
)
}
\arguments{
\item{dir}{The directory in which data, inputs, and outputs are to be stored. Must be supplied.}

\item{mrdata}{The R dataframe containing the multiple-record dataset. Must be supplied.}

\item{indicators}{The names of all indicators (items, observed variables) in the MNLFA.}

\item{catindicators}{The list of indicators which are categorical. Defaults to NULL.}

\item{countindicators}{The list of indicators which are count. Defaults to NULL.}

\item{meanimpact}{The list of covariates (predictors) which may generate impact on the latent variable mean. Defaults to NULL.}

\item{varimpact}{The list of covariates (predictors) which may generate impact on the latent variable variance. Defaults to NULL.}

\item{measinvar}{The list of covariates (predictors) which may generate DIF. Defaults to NULL.}

\item{factors}{The list of covariates which are categorical. Defaults to NULL.}

\item{time}{The variable which indexes time (or multiple records within a single case). If left blank, assumes single-record data. Defaults to NULL.}

\item{auxiliary}{The list of variables to be considered as auxiliary (i.e., retained in the dataset but not used in the analysis). Defaults to NULL.}

\item{ID}{The variable which identifies cases. Defaults to NULL.}

\item{thresholds}{A Boolean operator indicating whether to test for threshold DIF.}
}
\value{
A object of type aMNLFA.object, which is a list of all the above arguments that can be passed to each aMNLFA function (except aMNLFA_DIFplot, which takes the output from aMNLFA.prune()).
}
\description{
This function creates an aMNLFA object based on user specifications to pass to aMNLFA functions.
}
\examples{
 wd <- tempdir()
 first<-paste0(system.file(package='aMNLFA'),"/extdata")
 the.list <- list.files(first,full.names=TRUE)
 file.copy(the.list,wd,overwrite=TRUE)
 
 ob <- aMNLFA::aMNLFA.object(dir = wd, 
 mrdata = xstudy, 
 indicators = paste0("BIN_", 1:12),
 catindicators = paste0("BIN_", 1:12), 
 meanimpact = c("AGE", "GENDER", "STUDY"), 
 varimpact = c("AGE", "GENDER", "STUDY"), 
 measinvar = c("AGE", "GENDER", "STUDY"),
 factors = c("GENDER", "STUDY"),
 ID = "ID",
 thresholds = FALSE)
 
}
\keyword{MNLFA}
