% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Squarefree.R
\name{Squarefree}
\alias{Squarefree}
\alias{A005117}
\title{Squarefree numbers}
\usage{
Squarefree(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A005117}{A005117}, a \emph{Squarefree} number is
a number that are not divisible by a square of a smaller integer greater than 1. First 6 Squarefree numbers are  1, 2, 3, 5, 6, 7.
}
\examples{
## generate first 30 Squarefree numbers
first30 = Squarefree(30)

## print without trailing 0's.
print(first30, drop0trailing = TRUE)

}
