\name{ellipseLexCA}
\encoding{latin1} 
\alias{ellipseLexCA}

\title{Confidence ellipses on textual correspondence analysis graphs}

\description{
Draws confidence ellipses around documents and/or words on a textual CA graph.
}


\usage{
ellipseLexCA(object, selWord="ALL", selDoc="ALL", nbsample=100, axes=c(1, 2),
    xlim=NULL, ylim=NULL, title=NULL, col.doc="blue", col.word="red", 
    col.doc.ell=col.doc, col.word.ell=col.word, cex=1) 
}

\arguments{
 \item{object}{object of LexCA class}
 \item{selWord}{selected words (indexes or names; by default "ALL"); see the details section}
 \item{selDoc}{selected docs (indexes or names; by default "ALL"); see the details section}
 \item{nbsample}{number of samples drawn to evaluate the stability of the points}
 \item{axes}{length 2 vector specifying the dimensions to plot}
 \item{xlim}{range for the plotted 'x' values, defaulting to the range of the finite values of 'x' (by default NULL)}
 \item{ylim}{range for the plotted 'y' values, defaulting to the range of the finite values of 'y' (by default NULL)}
 \item{title}{title of the graph (by default NULL and the title is automatically assigned)}
 \item{col.doc}{color for the documents-points (by default "blue")}
 \item{col.word}{color for words-points (by default "red")}
 \item{col.doc.ell}{color for the ellipses around documents-points (by default the same as col.doc)}
 \item{col.word.ell}{color for the ellipses around words-points (by default the same as col.word)}
 \item{cex}{text and symbol size is scaled by cex, in relation to size 1 (by default 1)}
}


\value{
Returns a LexCA-like map representing the selected points and their confidence ellipses
}

\details{

The method "multinomial" is used to generate the replicated tables. 
So, the active lexical table contained in the LexCA object (active table) is taken as a reference.

Then, replicated lexical tables are generated by repeating nbsample times the following process: N (the sum of active table elements) values are drawn from a multinomial distribution with theoretical frequencies equal to the values in the active table cells divided by N. A replicated table is built from each drawing.

The nbsample documents-rows and/or words-columns of the replicated tables are projected as supplementary documents (rows) and/or supplementary words (columns) on the graph computed from the active lexical table. 
Then, confidence ellipses are drawn around each active element from the nbsample supplementary points.\cr
The replicated samples with empty row-documents and/or word-columns with null frequency are dropped. \cr 
If over 10\% of the total of replicated samples are dropped, the execution is stopped. Information is given through a stop-message.\cr

The selDoc and selWord arguments allow for selecting the documents and/ or words.\cr
The syntax for these arguments is similar to the one used in plot.LexCA. \cr 
However they only concern the active elements and selecting the characteristic words is not allowed.

Some examples follow:
selDoc=c(1:5): the documents 1 to 5 are represented.\cr
selDoc=c("doc1","doc5"): documents with labels doc1 or doc5 are represented.\cr
selWord=c("word1","word3"): words with labels word1 or word3 are represented.\cr
selDoc/selWord = "coord 10": the 10 documents/words with the highest coordinates on the 2
 chosen axes are selected.\cr
selDoc/selWord="contrib 10": documents/words with a contribution to the inertia of any of both axes over 10\% of the axis inertia are selected.\cr
selDoc/selWord="cos2 0.85: the documents/words with cos2 over 0.85 (as summed on the 2 axes) are selected.\cr
selDoc ="meta 3": documents/words with a contribution over 3 times the average document/word contribution on any of both axes are selected.\cr
}

\references{
Husson F., Le S., Pages J. (2011). Exploratory Multivariate Analysis by Example Using R. Chapman & Hall/CRC. <doi:10.1080/02664763.2012.657409>.

Lebart, L., Piron, M., & Morineau, A. (2006). Statistique exploratoire multidimensionnelle. (Dunod, Ed.).

Lebart, L., Salem, A., & Berry, L. (1998). Exploring textual data. (Kluwer, Ed.). <doi:10.1007/978-94-017-1525-6>.
}

\author{Monica Bcue-Bertaut, Ramn Alvarez-Esteban \email{ramon.alvarez@unileon.es}, Josep-Antn Snchez-Espigares}

\seealso{ \code{\link{LexCA}}, \code{\link{print.LexCA}},  \code{\link{plot.LexCA}}, \code{\link{summary.LexCA}}}

\examples{
\dontrun{
data(open.question)
res.TD<-TextData(open.question, var.text=c(9,10), remov.number=TRUE, Fmin=10, Dmin=10,  
  stop.word.tm=TRUE, context.quali=c("Gender","Age_Group","Education"), 
  context.quanti=c("Age"))
res.LexCA<-LexCA(res.TD, graph=FALSE,ncp=8)
ellipseLexCA(res.LexCA, selWord="meta 1",selDoc=NULL, col.word="brown")
ellipseLexCA(res.LexCA, selWord="contrib 10",selDoc=NULL, col.word="brown")
ellipseLexCA(res.LexCA, selWord=c("work","job","money","comfortable"), selDoc=NULL,
  col.word="brown")
ellipseLexCA(res.LexCA, selWord="cos2 0.2", selDoc=NULL, col.word="brown")
}
\dontrun{
data(open.question)
res.TD<-TextData(base, var.text=c(9,10), var.agg="Sexe_Age", Fmin=10, Dmin=10,
  remov.number=TRUE, stop.word.tm=TRUE)
res.LexCA<-LexCA(res.TD, graph=FALSE)
ellipseLexCA(res.LexCA, selWord=NULL, col.doc="black")
ellipseLexCA(res.LexCA, selWord="meta 3", selDoc=NULL, col.word="brown")
ellipseLexCA(res.LexCA, selWord="contrib 10", selDoc=NULL, col.word="brown")
ellipseLexCA(res.LexCA, selWord=c("work","job","money","comfortable"), selDoc=NULL,
       col.word="brown")
ellipseLexCA(res.LexCA, selWord="cos2 0.2", selDoc=NULL, col.word="brown")    
	}
}
\keyword{multivariate}

