% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/Interface.R
\docType{class}
\name{Interface-class}
\alias{Interface}
\alias{Interface-class}
\title{Reference class for all interface evaluators}
\description{
This class has the fields required for any specific interface and the methods that
are defined centrally in the XR structure.  As noted in the documentation for inidividual
methods, some methods must be redefined in the specific interface.
}
\section{Fields}{

\describe{
\item{\code{evaluatorId}}{A character string (usually unique) giving the language and date when started}

\item{\code{languageName}}{The server language.  Does not have to be unique if multiple classes implement interfaces to the same language.}

\item{\code{proxyCount}}{Counter used to generate unique names for proxy objects.}

\item{\code{propertyFormat}}{C-style format string for access to properties and methods in this
evaluator.  Nearly always just the two names, separated by "."}

\item{\code{proxyClassTable}}{An environment for all proxy classes known currently for this
evaluator class.}

\item{\code{prototypeObject}}{The object representing any proxy class for this inteface.  Usually from
a class defined by the specific interface package, to distinguish its proxy classes. This
field is passed as the \code{prototype} argument in calls to \code{\link{asServerObject}}.}

\item{\code{simplify}}{Should lists whose elements are each basic scalars be unlisted?
Default FALSE.  May also be a function that takes a possibly simplifiable
list as argument and returns the vector/list result.
Use this to apply a customized test; e.g., all scalars must have same type.}

\item{\code{propertyFormat}}{The C-style format for a property (i.e., field) in the server language.
The default assumes \code{"."} is the field operator, as in all likely server languages so far.}

\item{\code{proxyClassTable}}{Used to keep track of proxy classes encountered}

\item{\code{modules}}{The evaluator's table of currently imported modules.}

\item{\code{serverPath}}{The evaluator's current server language path for importing.}
}}
\section{Methods}{

\describe{
\item{\code{AddToPath(directory = base::tolower(languageName),
  package = utils::packageName(topenv(parent.frame())), pos = NA)}}{Add the directory to the systemPath
By default, appends to the path; if `pos` is given, inserts at that position.
If both directory and package are omitted, the method looks for the package name in the
calling function (suitable if the method call is from a package source file).}

\item{\code{AsRObject(object)}}{Given an R object made up of vectors, lists and named tables, interpret that as a general R object,
using a convention that may be specialized to the server language by overriding
$AsRObject() or by methods for asRObject().  The argument will may be from a proxy class.}

\item{\code{AsServerObject(object, prototype = prototypeObject)}}{Given an R object return a string that, when evaluated in the server language gives
a corresponding object in that language.  The default implementation uses the function
XR::objectAsJSON, which returns a JSON string and assumes a function `objectFromJSON(string)`
in the server. The conversion may be specialized to server language classes by methods for
asServerObject() or objectAsJSON().}

\item{\code{Call(fun, ..., .get = NA)}}{Call the server language function `fun`.  Each of the `...` arguments will be
translated into a server language expression by the AsServerObject() method.}

\item{\code{Command(expr, ...)}}{Like Eval(), but the value of the expression is ignored.  In particular, may be a command
in the server language that is not an expression.}

\item{\code{Eval(expr, ..., .get = NA)}}{Evaluate `expr` and return the value, possibly as a proxy.
Expressions are supplied as character strings to be parsed and
evaluated by the server language. If `expr` has "%s" fields, they are filled in
with the appropriate server language code equivalent to the `...` arguments.  If `expr` has
more than one element, all but the last are evaluated by $Command(), with `...` ignored.}

\item{\code{finalize(...)}}{method called when the object is garbage collected.  A call to the $Quit() method
also calls this method (recalling it later then does nothing).  In case some server action
(like closing down a subprocess) is required, the $ServerQuit() method is called, and
the evaluator is then removed from the table of interface evaluators.}

\item{\code{Function(serverFun)}}{Returns an R function object that calls the specified sever language function,
specified by its name in the server language or by the proxy object returned by the
$Define() method of the evaluator}

\item{\code{Get(what, ...)}}{Return the value, always converted to an R object.  Usually gets a proxy object as the argument, but can be called like $Eval(), if ... is non-empty.}

\item{\code{Import(module, ...)}}{Import the module.  The "Interface" method assumes a command "import" in the server
language and does not handle any extra arguments (e.g., for importing specific members).}

\item{\code{initialize(...)}}{initializes the evaluator in a language-independent sense.}

\item{\code{MethodCall(object, name, ..., .get = NA)}}{Call the server language method `name` on `object`, with arguments `...`,
by default assuming a language in which the syntax is `object.name(...)`.
To override with a different syntax, define field propertyFormat in the evaluator.
Note that `name` must be a character string, not an evaluation in the server.}

\item{\code{MethodEval(string, catch = FALSE, print = FALSE)}}{The string is a method call for the evaluator, or the name of a field.
Evaluated as the expression ev$string.}

\item{\code{New(serverClass, serverModule = "", ...)}}{Generate a new object from the specified server class.  The corresponding generator function
in the server is given by ServerGenerator(serverClass), by default just the class name.
Typically called from the $Initialize() method of the proxy class.}

\item{\code{ProxyClassName(serverClass)}}{If there is a proxy class defined corresponding to this serverClass, return the name
of that class (typically pasted with the server langauge, separated by underscore).  If no
such class is defined, return NA.}

\item{\code{ProxyClassObject(object)}}{If `object` is an assigned proxy, check whether the serverClass is a known proxy class
and if so, return an object from that class; otherwise return `object`.}

\item{\code{ProxyName(x, new = TRUE)}}{Called without arguments, returns a key for the next proxy object.  In the default strategy, this is a string
"R_i_j" where i is the sequence code for the evaluator and j is the proxy count,
incremented if `new` is TRUE.  If `x` is supplied as an existing proxy object,
returns the key for that object.}

\item{\code{SaveProxyFunction(save, object, objName = obj@name, docText = NULL,
  docFunction = createRoxygen)}}{The object is an expanded function definition, provided by the initialize method for this class.
`save` should be either an environment in which to assign it or a place to dump the R source, either an
open connection or a file name.}

\item{\code{Send(object, serverClass = "", .key = NULL)}}{Send the converted version of `object` to the server language.
If `.key` is specified, assign it under that name.  By default (and recommended)
a proxy object in R provides the name for the converted object.
If `serverClass` is supplied, there should be a corresponding asServerObject() method.}

\item{\code{Serialize(object, file, append = FALSE)}}{Use the server language serialization to serialize `object` to the specified `file`.
According to `append` either append to the file (default) or overwrite.
The supplied object should be a proxy for a server language object.}

\item{\code{ServerClass(Class, module)}}{If possible, return the class structure of Class, a class in the server language.
module= is the server module/package/library in which Class is defined, or "".
If no reflection information is available, return NULL (which this definition does).
Should return a list or reference object: "$fields" and "$methods" should be character
vectors or named lists of the server fields and metohds.}

\item{\code{ServerClassDef(Class, module, ...)}}{Individual interface packages will define this to return a named list or other object such that value$fields and value$methods are the server fields and methods, character vectors
of names or named objects whose elements give further information.  This default version
returns NULL, indicating that no metadata is available.}

\item{\code{ServerEval(expr, key, get)}}{Must be defined by the server language interface: evaluates `expr`(a text string).
If `key` is an empty string, `expr` is treated as a directive, with no defined value.
Otherwise, `key` is a non-empty string, and the server
object should be assigned with this name. The value returned is the R result, which may
be an AssignedProxy() object. If `get` is TRUE or the value judged simple enough,
it will be converted to an ordinary R object instead.}

\item{\code{ServerExpression(...)}}{The arguments define an expression in the server language.
The first argument is a string; any others are objects to be substituted for %s fields
in the string.  These can include proxy objects or R data.}

\item{\code{ServerFunctionDef(name, module = "", ...)}}{The XR method defines the proxy function with no special metadata information.
Server langugae metadata may be used by a method that overrides this one, and calls it.}

\item{\code{ServerRemove(key)}}{Should be defined by the server language interface:
    The reference previously created for `key` should be removed.
What happens has no effect on the client side; the intent is to potentially recover memory.}

\item{\code{ServerSerialize(key, file)}}{Serialize the proxy function corresponding to `key` to the specified `file`.
Will normally be defined using the serialization supported by the particular server
language. The default gets the object and serializes in R, so only works if conversion does}

\item{\code{ServerUnserialize(file, all)}}{Unserialize the file, returning a proxy object for a list, or equivalent in the server
language, of all the objects serialized to this file.  Because open connections can not
generally be shared among languages, must unserialize the entire file.}

\item{\code{Shell(endCode = "quit", prompt = ">>>: ", cont = "+++: ")}}{Starts an interactive shell.  Each line of input must be a complete expression
or statement in the server language. To continue over multiple lines, append an unescaped
backslash to all but the last line.

A line typed to the shell starting with "$" is an escape back to the evaluator, and
can be used to call evaluator methods, e.g., "ProxyName(x)".  See the example in
the documentation for class "Interface" in XR}

\item{\code{Source(filename)}}{Parse and evaluate the contents of the file.  This method is likely to be overriden for particular langauges
with a directive to include the contents of the file.  The `XR` version reads the file and processes the entire contents
as a single string, newlines inserted between lines of the file.}

\item{\code{startupActions()}}{Perform the evaluator actions specified for this object, typically additions to search path and imports}

\item{\code{Unserialize(file, all = FALSE)}}{Unserialize the objects previously written to `file` by $Serialize().
Returns a list of proxy objects (always a list even if only one object found).}
}}
\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 12, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}

