% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xMarkNet.r
\name{xMarkNet}
\alias{xMarkNet}
\title{Function to mark a network within another network}
\usage{
xMarkNet(ig1, ig2, verbose = TRUE)
}
\arguments{
\item{ig1}{a "igraph" object within which the mark happens}

\item{ig2}{a "igraph" object to be marked. Only overlapped nodes and
edges are marked}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
an object of class "igraph" appended with a node attribute 'mark' (0
for the background, 1 for the marked) and an edge attribute 'mark' (0
for the background, 1 for the marked)
}
\description{
\code{xMarkNet} is supposed to mark a network within another network.
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
ig1 <- xDefineNet(network="KEGG_environmental",
RData.location=RData.location)
ig2 <- xDefineNet(network="KEGG_organismal",
RData.location=RData.location)
ig <- xMarkNet(ig1, ig2)

E(ig)$color <- ifelse(E(ig)$mark==0, 'lightblue1', 'darkgreen')
E(ig)$color.alpha <- ifelse(E(ig)$mark==0, 0.3, 0.7)
ig <- ig \%>\% xLayout("gplot.layout.fruchtermanreingold")
gp <- xGGnetwork(ig, node.xcoord='xcoord', node.ycoord='ycoord',
node.color="mark", colormap="orange-darkgreen", node.color.alpha=0.7,
edge.color="color", edge.color.alpha="color.alpha", edge.arrow.gap=0) +
theme(legend.position='none')
}
}
\seealso{
\code{\link{xMarkNet}}
}
