% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xHEB.r
\name{xHEB}
\alias{xHEB}
\title{Function to visualise a graph with communities using hierarchical edge bundling}
\usage{
xHEB(g, leave.label.size = 3, leave.label.color = "black",
leave.size = NULL, edge.tension = 0.8, edge.alpha = 1,
edge.width = 0.5, edge.palette = NULL)
}
\arguments{
\item{g}{an object of class "igraph" with node attributes 'name' and
'community'}

\item{leave.label.size}{the text size of the leave labelings. By
default, it is 3}

\item{leave.label.color}{the color of the leave labelings. By default,
it is 'black'. If NULL, the label will be colored by the community}

\item{leave.size}{the size of the leave nodes. By default, it is 3 if
there is no node attribute 'size'}

\item{edge.tension}{the bundling strength of edges. 1 for very tight
bundles, 0 for no bundle (straight lines). By defaults it is 0.8}

\item{edge.alpha}{the alpha of edges}

\item{edge.width}{the width of edges}

\item{edge.palette}{the palette defining edge color. It is correponding
to the edge attribute 'weight' for the input graph (if any). By
default, it is NULL: if the edge attribute 'weight' exists for the
input graph, it will be 'RdPu' (RColorBrewer::display.brewer.all());
otherwise 'skyblue'}
}
\value{
a ggplot2 object
}
\description{
\code{xHEB} is supposed to visualise a graph with communities using
hierarchical edge bundling (HEB), an effective way to visualise
connections between leaves of a hierarchical/tree graph (representing
the community structure). The connections are curved and follow the
tree structure (in a circular layout). It returns a ggplot object.
}
\examples{
# 1) generate a random bipartite graph
set.seed(123)
g <- sample_bipartite(50, 20, p=0.1)
V(g)$name <- paste0('node_',1:vcount(g))

\dontrun{
# 2) obtain its community
ig <- xBigraph(g)

# 3) HEB visualisation
library(ggraph)
E(ig)$weight <- runif(ecount(ig))
gp <- xHEB(ig)
}
}
\seealso{
\code{\link{xHEB}}
}
