% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGScore.r
\name{xGScore}
\alias{xGScore}
\title{Function to extract scores given a list of genomic regions}
\usage{
xGScore(data, format = c("chr:start-end", "data.frame", "bed",
"GRanges"),
build.conversion = c(NA, "hg38.to.hg19", "hg18.to.hg19"),
GS.annotation = c("fitCons", "phastCons", "phyloP", "mcap", "cadd"),
scoring.scheme = c("mean", "median", "max", "min", "sum"), verbose = T,
RData.location = "http://galahad.well.ox.ac.uk/bigdata_dev")
}
\arguments{
\item{data}{input genomic regions (GR). If formatted as "chr:start-end"
(see the next parameter 'format' below), GR should be provided as a
vector in the format of 'chrN:start-end', where N is either 1-22 or X,
start (or end) is genomic positional number; for example, 'chr1:13-20'.
If formatted as a 'data.frame', the first three columns correspond to
the chromosome (1st column), the starting chromosome position (2nd
column), and the ending chromosome position (3rd column). If the format
is indicated as 'bed' (browser extensible data), the same as
'data.frame' format but the position is 0-based offset from chromomose
position. If the genomic regions provided are not ranged but only the
single position, the ending chromosome position (3rd column) is allowed
not to be provided. The data could also be an object of 'GRanges' (in
this case, formatted as 'GRanges')}

\item{format}{the format of the input data. It can be one of
"data.frame", "chr:start-end", "bed" or "GRanges"}

\item{build.conversion}{the conversion from one genome build to
another. The conversions supported are "hg38.to.hg19" and
"hg18.to.hg19". By default it is NA (no need to do so)}

\item{GS.annotation}{which genomic scores (GS) annotaions used. It can
be 'fitCons' (the probability of fitness consequences for point
mutations; \url{http://www.ncbi.nlm.nih.gov/pubmed/25599402}),
'phastCons' (the probability that each nucleotide belongs to a
conserved element/negative selection [0,1]), 'phyloP' (conservation at
individual sites representing -log p-values under a null hypothesis of
neutral evolution, positive scores for conservation and negative scores
for acceleration), 'mcap' (eliminating a majority of variants with
uncertain significance in clinical exomes at high sensitivity:
\url{http://www.ncbi.nlm.nih.gov/pubmed/27776117}), and 'cadd'
(combined annotation dependent depletion for estimating relative levels
of pathogenicity of potential human variants:
\url{http://www.ncbi.nlm.nih.gov/pubmed/24487276})}

\item{scoring.scheme}{the method used to calculate scores spanning a
set of GR. It can be one of "mean", "median", "max", "min" and "sum"}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a GenomicRanges object
}
\description{
\code{xGScore} is supposed to extract scores given a list of genomic
regions. Scores for genomic regions/variants can be
constraint/conservation or impact/pathogenicity. It returns a GR
object.
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev"

# a) provide the genomic regions
## load ImmunoBase
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase',
RData.location=RData.location)
## get lead SNPs reported in AS GWAS
data <- ImmunoBase$AS$variant

# b) extract fitness consequence score
gr <- xGScore(data=data, format="GRanges", GS.annotation="fitCons",
scoring.scheme="mean", RData.location=RData.location)
}
}
\seealso{
\code{\link{xRDataLoader}}
}
