% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPlots.R
\name{addPlots}
\alias{addPlots}
\title{Read Word document with bookmarks and create other Word documnet with rendered plots in place.}
\usage{
addPlots(docxIn, docxOut, Plots = list(), debug = F, ...)
}
\arguments{
\item{docxIn}{String of length one; path to Word file with bookmarks.}

\item{docxOut}{String of length one; path for output Word file.}

\item{Plots}{Named list of function creating plots (see \code{\link[ReporteRs]{addPlot}}) for details) to be inserted into the Word file}

\item{debug}{Boolean of length one; If \code{True} then \code{\link[base]{browser}()} is called at the beginning of the function}

\item{...}{Parameters to be sent to other methods (mainly \code{\link[ReporteRs]{addPlot}})}
}
\value{
Path to the rendered Word file if the operation was successfull.
}
\description{
This function is basically a loop wrapper around \code{\link[ReporteRs]{addPlot}} function.
}
\examples{
library(ggplot2)
Plots<-list(plot1=function()plot(hp~wt,data=mtcars,col=cyl),
 plot2=function()print(ggplot(mtcars,aes(x=wt,y=hp,col=as.factor(cyl)))+geom_point()))
addPlots(
 paste(examplePath(),'templates/templatePlots.docx',sep = ''),
 paste(examplePath(),'results/resultPlots.docx',sep = ''),
 Plots,height=4)

}
