% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/userContribs.R
\name{userContribs}
\alias{userContribs}
\title{lists contributions for a specific user}
\usage{
userContribs(user.name = NULL, domain = "en",
  ucprop = "ids|title|timestamp|comment|sizediff|flags")
}
\arguments{
\item{user.name}{a character value providing the name of the user}

\item{domain}{a character value providing the language of the wikipedia page. The default value is "en" for "english language".}

\item{ucprop}{Include informations (separate with '|') :
\itemize{
\item{ids}{ the page ID and revision ID}
\item{title}{ the title and namespace ID of the page. This parameter is not optional.}
\item{timestamp}{ the timestamp of the edit, i.e. day and time}
\item{comment}{ the comment of the edit}
\item{parsedcomment}{ the parsed comment of the edit}
\item{size}{ the new size of the edit}
\item{sizediff}{ the size delta of the edit against its parent}
\item{flags}{ flags of the edit}
\item{patrolled}{ patrolled edits}
\item{tags}{ tags for the edit}
}
Default: ids|title|timestamp|comment|sizediff|flags}
}
\value{
an object of class \code{userContribsClass}:
\itemize{
\item{\code{call}}{ the command line}
\item{\code{user}}{ a vector containing the user name and the user identifier}
\item{\code{contribs}}{ a data frame containing the asked properties of the revisions. 
If ids is asked, the corresponding results are pageid, revid, and parentid. 
Three others informations are automatically added : 
 \code{ns}, numbers of the namespaces (identification of the type of pages, defining nscat et nssubj, the two next variables), 
 \code{nscat}, the categories of linked pages (Subject, Talk, or Virtual), 
 \code{nssubj}, the subjects of the linked pages (Main Article, User, Wikipedia, File, MediaWiki, Template, Help, Category, Protal, Book, Draft, Education Program, TimedText, Module, Topic, Special, Media, Other) . 
This item is provided if the user has at least one contribution.
For more details about namespace, see \url{http://www.mediawiki.org/wiki/Help:Namespaces} and \url{http://en.wikipedia.org/wiki/Wikipedia:Namespace#Subject_namespaces}
  }
\item{\code{testWikiUser}}{ A list of three elements. 
 The first is \code{takeOnlyFirst}, a boolean indicating if the class of \code{user.name} parameter is invalid, 
 for example vector, list, matrix..., and in that case, the only the first element is considered.
   The second element is \code{test}, an integer with value: 
   \itemize{
   \item{4}{ for invalid domain,}
   \item{3}{ for an empty parameter user,}
   \item{2}{ when Wikipedia does not have an user with this exact name,}
   \item{0}{ for valid existing user. }
   }
 The last element, \code{warnMessage}, is a vector of warning messages.
 }
}
}
\description{
lists contributions for a specific user: discussions for Talk pages, and revisions for Subject pages.
}
\details{
This function uses the API query syntax: "list=usercontribs". 
For more details, see \url{https://www.mediawiki.org/wiki/API:Usercontribs}
Additionnally to the titles of the modified pages, this function always returns in the contribs item the ns for namespace (identifcation of the type of pages), 
the nscat for the category of the pages (Subject, Talk, or Virtual), and the subject of the pages.
}
\examples{
\dontrun{
LouiseContribs <- userContribs(user.name = "Louise", domain = "en")
## try a user that does not exist (at the moment of the redaction of this help page)
userContribs(user.name="Louise Baschet", domain ="fr")
}
}
\author{
Avner Bar-Hen, Louise Baschet, Francois-Xavier Jollois, Jeremie Riou
}
\seealso{
userInfo
}

