% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links.R
\name{links}
\alias{links}
\title{lists links on a Wikipedia page}
\usage{
links(page = NULL, domain = "en")
}
\arguments{
\item{page}{numeric identifier or character title of the specific wikipedia page}

\item{domain}{a character value specifying the language of the wikipedia url.The default value is "en" for "english language".}
}
\value{
an object of class \code{linksClass} containing:
\itemize{
\item{\code{call}}{ the command line}
\item{\code{page} }{title, identification number, and domain of the Wikipedia page}
\item{\code{links}}{ a data frame containing \code{title}, the titles of the linked pages, 
 \code{ns}, numbers of the namespaces (identification of the type of pages, defining nscat et nssubj, the two next variables),  
 \code{nscat}, the categories of linked pages (Subject, Talk, or Virtual), 
 \code{nssubj}, the subjects of the linked pages (Main Article, User, Wikipedia, File, MediaWiki, Template, Help, Category, Protal, Book, Draft, Education Program, TimedText, Module, Topic, Special, Media, Other). 
For more details about namespace, see \url{http://www.mediawiki.org/wiki/Help:Namespaces} and \url{http://en.wikipedia.org/wiki/Wikipedia:Namespace#Subject_namespaces}
 }
\item{\code{extlinks}}{ a vector containing the list of url of external links. If there is no external link in the page, this item is not created.}
\item{\code{testWikiPage}}{a list of four elements,
   \itemize{
   \item{\code{takeOnlyFirst}}{ a boolean indicating if the class of \code{page} parameter is invalid, 
             for example vector, list, matrix..., and in that case, only the first element is considered.}
   \item{\code{redirPage}}{ title of the redirected url. This item is NULL if the page is not redirected.}
   \item{\code{test}}{ an integer with value: 
     \itemize{
     \item{4}{ for invalid domain,}
     \item{3}{ for an empty parameter page,}
     \item{2}{ when Wikipedia does not have an article with this exact name,}
     \item{1}{ for ambiguous page, direct or redirect,} 
     \item{0}{ for valid an unambiguous page, direct or redirect. }
     }
   }
   \item{\code{warnMessage}}{ is a vector of warning messages.}
   }
}
}
}
\description{
lists all links (to wikipedia and to external url) that are present in a specific wikipedia page.
}
\details{
This function uses the MediaWiki API query syntax: "prop=links". 
For more details, see \url{http://www.mediawiki.org/wiki/API:Properties#links_.2F_pl}.
}
\examples{
\dontrun{
# a simple example
links("Louis Pasteur") # default domain : en

# with a redirected page
links.Obama <- links(page ="Obama")
links.Obama
# warning message

# a simple example with page specified by its page ID number
links(page = 976, domain = "fr" )

# with a page that not exist (at the moment of the redaction of this help page)
links("zzzzz") 
}
}
\author{
Avner Bar-Hen, Louise Baschet, Francois-Xavier Jollois, Jeremie Riou
}
\seealso{
print.linksClass backLinks
}

