\name{wiki_page}
\alias{wiki_page}
\title{
Retrieves MediaWiki pages
}
\description{
wiki_page retrieves the content and associated metadata from the most recent revision on a particular page.
}
\usage{
wiki_page(con, pages, properties = c("content", "ids", "flags",
                                     "timestamp", "user", "userid",
                                     "size", "sha1", "contentmodel",
                                     "comment", "parsedcomment", "tags"))
}
\arguments{
  \item{con}{
  A connector object, generated by \code{\link{wiki_con}}, that corresponds to the project you're trying to query.
}
  \item{pages}{
The page title(s) you care about
}
  \item{properties}{
  Properties associated with the most recent revision to the pages you specified. Options include "ids" (the revision ID of the revision), "flags" (whether the revision was 'minor' or not), "timestamp" (the timestamp of the revision, which can be parsed with \code{\link{wiki_timestamp}}), "user" (the username of the person who made that revision), "userid" (the userID of the person who made the revision), "size" (the size, in uncompressed bytes, of the revision), "sha1" (the SHA-1 hash of the revision text), "contentmodel" (the content model of the page, usually "wikitext"), "comment" (the revision summary associated with the revision), "parsedcomment" (the same, but parsed, generating HTML from any wikitext in that comment), "tags" (any tags associated with the revision) and "flagged" (the revision's status under Flagged Revisions)}
}

\seealso{
\code{\link{wiki_diff}} for retrieving 'diffs' between revisions, \code{\link{wiki_revision}} for retrieving the text of specified revisions.
}